/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliUtils {
    public static String interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return PatchouliAPI.instance.serializeIngredient(ingredients.get(0));
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.field_190927_a};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.func_203189_d()) {
                stacks.add(ingredient.func_193365_a());
                continue;
            }
            stacks.add(empty);
        }
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                joiner.add(PatchouliAPI.instance.serializeItemStack(stack[i % stack.length]));
            }
        }
        return joiner.toString();
    }

    public static String interweaveIngredients(List<Ingredient> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.func_193365_a().length).max().orElse(1));
    }
}

