/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public final class BossBarHandler {
    public static final Set<EntityDoppleganger> bosses = Collections.newSetFromMap(new WeakHashMap());
    public static final ResourceLocation defaultBossBar = new ResourceLocation("botania:textures/gui/boss_bar.png");
    private static final BarCallback barUniformCallback = new BarCallback();

    private BossBarHandler() {
    }

    public static void onBarRender(RenderGameOverlayEvent.BossInfo evt) {
        UUID infoUuid = evt.getBossInfo().func_186737_d();
        for (EntityDoppleganger currentBoss : bosses) {
            if (!currentBoss.getBossInfoUuid().equals(infoUuid)) continue;
            evt.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            Rectangle bgRect = currentBoss.getBossBarTextureRect();
            Rectangle fgRect = currentBoss.getBossBarHPTextureRect();
            String name = evt.getBossInfo().func_186744_e().func_150254_d();
            int c = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2;
            int x = evt.getX();
            int y = evt.getY();
            int xf = x + (bgRect.width - fgRect.width) / 2;
            int yf = y + (bgRect.height - fgRect.height) / 2;
            int fw = (int)((double)fgRect.width * (double)evt.getBossInfo().func_186738_f());
            int tx = c - mc.field_71466_p.func_78256_a(name) / 2;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int auxHeight = currentBoss.bossBarRenderCallback(x, y);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            mc.field_71446_o.func_110577_a(currentBoss.getBossBarTexture());
            BossBarHandler.drawBar(currentBoss, x, y, bgRect.x, bgRect.y, bgRect.width, bgRect.height, true);
            BossBarHandler.drawBar(currentBoss, xf, yf, fgRect.x, fgRect.y, fw, fgRect.height, false);
            mc.field_71466_p.func_175063_a(name, (float)tx, (float)(y - 10), 10617228);
            RenderSystem.enableBlend();
            int n = Math.max(bgRect.height, fgRect.height) + auxHeight;
            mc.field_71466_p.getClass();
            evt.setIncrement(n + 9);
        }
    }

    private static void drawBar(EntityDoppleganger currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        ShaderHelper.BotaniaShader program = currentBoss.getBossBarShaderProgram(bg);
        if (program != null) {
            ShaderCallback callback = currentBoss.getBossBarShaderCallback(bg);
            barUniformCallback.set(u, v, callback);
            ShaderHelper.useShader(program, barUniformCallback);
        }
        RenderHelper.drawTexturedModalRect(x, y, u, v, w, h);
        if (program != null) {
            ShaderHelper.releaseShader();
        }
    }

    private static class BarCallback
    implements ShaderCallback {
        int x;
        int y;
        ShaderCallback callback;

        private BarCallback() {
        }

        @Override
        public void call(int shader) {
            int startXUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"startX");
            int startYUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"startY");
            GlStateManager.func_227718_f_((int)startXUniform, (int)this.x);
            GlStateManager.func_227718_f_((int)startYUniform, (int)this.y);
            if (this.callback != null) {
                this.callback.call(shader);
            }
        }

        void set(int x, int y, ShaderCallback callback) {
            this.x = x;
            this.y = y;
            this.callback = callback;
        }
    }
}

