/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemFlugelEye
extends ItemRelic
implements ICoordBoundItem,
IManaUsingItem {
    private static final String TAG_LOCATION = "location";

    public ItemFlugelEye(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.func_177958_n() + Math.random());
                    float y1 = pos.func_177956_o() + 1;
                    float z1 = (float)((double)pos.func_177952_p() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.func_195594_a((IParticleData)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(0.05f - (float)Math.random() * 0.05f), 0.0);
                }
            } else {
                ItemStack stack = ctx.func_195996_i();
                GlobalPos loc = GlobalPos.func_218179_a((DimensionType)world.func_201675_m().func_186058_p(), (BlockPos)pos);
                ItemNBTHelper.set(stack, TAG_LOCATION, (INBT)loc.func_218175_a((DynamicOps)NBTDynamicOps.field_210820_a));
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 5.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        float x = (float)(living.func_226277_ct_() - Math.random() * (double)living.func_213311_cf());
        float y = (float)(living.func_226278_cu_() + Math.random());
        float z = (float)(living.func_226281_cx_() - Math.random() * (double)living.func_213311_cf());
        WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
        living.field_70170_p.func_195594_a((IParticleData)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        INBT nbt = ItemNBTHelper.get(stack, TAG_LOCATION);
        if (nbt == null) {
            return stack;
        }
        GlobalPos loc = GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt));
        int x = loc.func_218180_b().func_177958_n();
        int y = loc.func_218180_b().func_177956_o();
        int z = loc.func_218180_b().func_177952_p();
        int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_()) * 10.0f);
        if (loc.func_218177_a() == world.func_201675_m().func_186058_p() && (!(living instanceof PlayerEntity) || ManaItemHandler.instance().requestManaExact(stack, (PlayerEntity)living, cost, true))) {
            ItemFlugelEye.moveParticlesAndSound((Entity)living);
            living.func_70634_a((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            ItemFlugelEye.moveParticlesAndSound((Entity)living);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        PacketHandler.sendToNearby(entity.field_70170_p, entity, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.FLUGEL_EFFECT, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_145782_y()));
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        INBT nbt = ItemNBTHelper.get(stack, TAG_LOCATION);
        if (nbt != null) {
            return GlobalPos.func_218176_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt)).func_218180_b();
        }
        return null;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/flugel_eye");
    }
}

