/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.capability.FloatingFlowerImpl;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.tile.TileMod;

public class TileFloatingFlower
extends TileMod {
    @ObjectHolder(value="botania:mini_island")
    public static TileEntityType<TileFloatingFlower> TYPE;
    private static final String TAG_FLOATING_DATA = "floating";
    private final IFloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public ItemStack getDisplayStack() {
            Block b = TileFloatingFlower.this.func_195044_w().func_177230_c();
            if (b instanceof BlockFloatingFlower) {
                return new ItemStack((IItemProvider)ModBlocks.getShinyFlower(((BlockFloatingFlower)b).color));
            }
            return ItemStack.field_190927_a;
        }
    };
    private final LazyOptional<IFloatingFlower> floatingDataCap = LazyOptional.of(() -> this.floatingData);

    public TileFloatingFlower() {
        super(TYPE);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == TileEntitySpecialFlower.FLOATING_FLOWER_CAP) {
            return this.floatingDataCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        IFloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        super.onDataPacket(net, packet);
        if (oldType != this.floatingData.getIslandType()) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_218657_a(TAG_FLOATING_DATA, TileEntitySpecialFlower.FLOATING_FLOWER_CAP.writeNBT((Object)this.floatingData, null));
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        TileEntitySpecialFlower.FLOATING_FLOWER_CAP.readNBT((Object)this.floatingData, null, (INBT)cmp.func_74775_l(TAG_FLOATING_DATA));
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(BotaniaStateProps.FLOATING_DATA, (Object)this.floatingData).build();
    }
}

