/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.core.helper.InventoryHelper;

public class BlockPrism
extends BlockModWaterloggable
implements IManaTrigger,
IManaCollisionGhost {
    private static final VoxelShape SHAPE = BlockPrism.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockPrism(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u, BotaniaStateProps.HAS_LENS});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean isHeldItemLens;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TilePrism)) {
            return ActionResultType.PASS;
        }
        TilePrism prism = (TilePrism)tile;
        ItemStack lens = prism.getItemHandler().getStackInSlot(0);
        ItemStack heldItem = player.func_184586_b(hand);
        boolean bl = isHeldItemLens = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ILens;
        if (lens.func_190926_b() && isHeldItemLens) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            prism.getItemHandler().setStackInSlot(0, heldItem.func_77946_l());
        } else if (!lens.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)lens);
            prism.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
        if (!world.field_72995_K) {
            if (power && !powered) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
            } else if (!power && powered) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TilePrism();
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePrism) {
            ((TilePrism)tile).onBurstCollision(burst);
        }
    }

    @Override
    public boolean isGhost(BlockState state, World world, BlockPos pos) {
        return true;
    }
}

