/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.block.tile.TileMod;

public class TileCorporeaRetainer
extends TileMod {
    @ObjectHolder(value="botania:corporea_retainer")
    public static TileEntityType<TileCorporeaRetainer> TYPE;
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final Map<ResourceLocation, Function<CompoundNBT, ? extends ICorporeaRequestMatcher>> corporeaMatcherDeserializers;
    private static final Map<Class<? extends ICorporeaRequestMatcher>, ResourceLocation> corporeaMatcherSerializers;
    private BlockPos requestPos = BlockPos.field_177992_a;
    @Nullable
    private ICorporeaRequestMatcher request;
    private int requestCount;
    private int compValue;

    public TileCorporeaRetainer() {
        super(TYPE);
    }

    public void setPendingRequest(BlockPos pos, ICorporeaRequestMatcher request, int requestCount) {
        if (this.hasPendingRequest()) {
            return;
        }
        this.requestPos = pos;
        this.request = request;
        this.requestCount = requestCount;
        this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(requestCount);
        this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        InvWithLocation inv;
        if (!this.hasPendingRequest()) {
            return;
        }
        ICorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(this.field_145850_b, this.requestPos);
        if (spark != null && (inv = spark.getSparkInventory()) != null && inv.getWorld().func_175625_s(inv.getPos()) instanceof ICorporeaRequestor) {
            ICorporeaRequestor requestor = (ICorporeaRequestor)inv.getWorld().func_175625_s(inv.getPos());
            requestor.doCorporeaRequest(this.request, this.requestCount, spark);
            this.request = null;
            this.requestCount = 0;
            this.compValue = 0;
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        ResourceLocation reqType;
        super.writePacketNBT(cmp);
        cmp.func_74768_a(TAG_REQUEST_X, this.requestPos.func_177958_n());
        cmp.func_74768_a(TAG_REQUEST_Y, this.requestPos.func_177956_o());
        cmp.func_74768_a(TAG_REQUEST_Z, this.requestPos.func_177952_p());
        ResourceLocation resourceLocation = reqType = this.request != null ? corporeaMatcherSerializers.get(this.request.getClass()) : null;
        if (reqType != null) {
            cmp.func_74778_a(TAG_REQUEST_TYPE, reqType.toString());
            this.request.writeToNBT(cmp);
            cmp.func_74768_a(TAG_REQUEST_COUNT, this.requestCount);
        }
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        super.readPacketNBT(cmp);
        int x = cmp.func_74762_e(TAG_REQUEST_X);
        int y = cmp.func_74762_e(TAG_REQUEST_Y);
        int z = cmp.func_74762_e(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        ResourceLocation reqType = ResourceLocation.func_208304_a((String)cmp.func_74779_i(TAG_REQUEST_TYPE));
        this.request = reqType != null && corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.func_74762_e(TAG_REQUEST_COUNT);
    }

    public static <T extends ICorporeaRequestMatcher> void addCorporeaRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundNBT, T> deserializer) {
        corporeaMatcherSerializers.put(clazz, id);
        corporeaMatcherDeserializers.put(id, deserializer);
    }

    static {
        corporeaMatcherDeserializers = new ConcurrentHashMap<ResourceLocation, Function<CompoundNBT, ? extends ICorporeaRequestMatcher>>();
        corporeaMatcherSerializers = new ConcurrentHashMap<Class<? extends ICorporeaRequestMatcher>, ResourceLocation>();
    }
}

