/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileEnchanter
extends TileMod
implements ISparkAttachable,
ITickableTileEntity {
    @ObjectHolder(value="botania:enchanter")
    public static TileEntityType<TileEnchanter> TYPE;
    private static final String TAG_STAGE = "stage";
    private static final String TAG_STAGE_TICKS = "stageTicks";
    private static final String TAG_STAGE_3_END_TICKS = "stage3EndTicks";
    private static final String TAG_MANA_REQUIRED = "manaRequired";
    private static final String TAG_MANA = "mana";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ENCHANTS = "enchantsToApply";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final String[][] PATTERN;
    public static final LazyValue<IMultiblock> MULTIBLOCK;
    private static final LazyValue<IMultiblock> FORMED_MULTIBLOCK;
    public State stage = State.IDLE;
    public int stageTicks = 0;
    public int stage3EndTicks = 0;
    private int manaRequired = -1;
    private int mana = 0;
    public ItemStack itemToEnchant = ItemStack.field_190927_a;
    private final List<EnchantmentData> enchants = new ArrayList<EnchantmentData>();
    private static final Map<Direction.Axis, BlockPos[]> PYLON_LOCATIONS;

    public TileEnchanter() {
        super(TYPE);
    }

    public void onWanded(PlayerEntity player, ItemStack wand) {
        if (this.stage != State.IDLE || this.itemToEnchant.func_190926_b() || !this.itemToEnchant.func_77956_u()) {
            return;
        }
        List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 3)));
        int count = items.size();
        if (count > 0 && !this.field_145850_b.field_72995_K) {
            for (ItemEntity entity : items) {
                Enchantment enchant;
                Map enchants;
                ItemStack item = entity.func_92059_d();
                if (item.func_77973_b() != Items.field_151134_bR || (enchants = EnchantmentHelper.func_82781_a((ItemStack)item)).size() <= 0 || !this.isEnchantmentValid(enchant = (Enchantment)enchants.keySet().iterator().next())) continue;
                this.advanceStage();
                return;
            }
        }
    }

    private void gatherEnchants() {
        if (!this.field_145850_b.field_72995_K && this.stageTicks % 20 == 0) {
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 3)));
            boolean addedEnch = false;
            for (ItemEntity entity : items) {
                Map enchants;
                ItemStack item = entity.func_92059_d();
                if (item.func_77973_b() != Items.field_151134_bR || (enchants = EnchantmentHelper.func_82781_a((ItemStack)item)).size() <= 0) continue;
                Map.Entry e = enchants.entrySet().iterator().next();
                Enchantment ench = (Enchantment)e.getKey();
                int enchantLvl = (Integer)e.getValue();
                if (this.hasEnchantAlready(ench) || !this.isEnchantmentValid(ench)) continue;
                this.enchants.add(new EnchantmentData(ench, enchantLvl));
                this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.ding, SoundCategory.BLOCKS, 1.0f, 1.0f);
                addedEnch = true;
                break;
            }
            if (!addedEnch) {
                if (this.enchants.isEmpty()) {
                    this.stage = State.IDLE;
                } else {
                    this.advanceStage();
                }
            }
        }
    }

    private void gatherMana(Direction.Axis axis) {
        if (this.manaRequired == -1) {
            this.manaRequired = 0;
            for (EnchantmentData data : this.enchants) {
                this.manaRequired += (int)(5000.0f * ((float)(15 - Math.min(15, data.field_76302_b.func_77324_c().func_185270_a())) * 1.05f) * ((3.0f + (float)(data.field_76303_c * data.field_76303_c)) * 0.25f) * (0.9f + (float)this.enchants.size() * 0.05f) * (data.field_76302_b.func_185261_e() ? 1.25f : 1.0f));
            }
        } else if (this.mana >= this.manaRequired) {
            this.manaRequired = 0;
            for (BlockPos pylon : PYLON_LOCATIONS.get(axis)) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)pylon));
                if (!(te instanceof TilePylon)) continue;
                ((TilePylon)te).activated = false;
            }
            this.advanceStage();
        } else {
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                SparkHelper.getSparksAround(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
            }
            if (this.stageTicks % 5 == 0) {
                this.sync();
            }
        }
    }

    public void func_73660_a() {
        BlockState state = this.func_195044_w();
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(BotaniaStateProps.ENCHANTER_DIRECTION);
        for (BlockPos pylon : PYLON_LOCATIONS.get(axis)) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vec3i)pylon));
            if (!(tile instanceof TilePylon)) continue;
            boolean bl = ((TilePylon)tile).activated = this.stage == State.GATHER_MANA;
            if (this.stage != State.GATHER_MANA) continue;
            ((TilePylon)tile).centerPos = this.field_174879_c;
        }
        if (this.stage != State.IDLE) {
            ++this.stageTicks;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (((IMultiblock)FORMED_MULTIBLOCK.func_179281_c()).validate(this.field_145850_b, this.field_174879_c.func_177977_b()) == null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150368_y.func_176223_P());
            PacketHandler.sendToNearby(this.field_145850_b, this.field_174879_c, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ENCHANTER_DESTROY, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, new int[0]));
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.enchanterFade, SoundCategory.BLOCKS, 0.5f, 10.0f);
        }
        switch (this.stage) {
            case GATHER_ENCHANTS: {
                this.gatherEnchants();
                break;
            }
            case GATHER_MANA: {
                this.gatherMana(axis);
                break;
            }
            case DO_ENCHANT: {
                if (this.stageTicks < 100) break;
                for (EnchantmentData data : this.enchants) {
                    if (EnchantmentHelper.func_77506_a((Enchantment)data.field_76302_b, (ItemStack)this.itemToEnchant) != 0) continue;
                    this.itemToEnchant.func_77966_a(data.field_76302_b, data.field_76303_c);
                }
                this.enchants.clear();
                this.manaRequired = -1;
                this.mana = 0;
                this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.enchanter, 0, 0);
                this.advanceStage();
                break;
            }
            case RESET: {
                if (this.stageTicks < 20) break;
                this.advanceStage();
                break;
            }
        }
    }

    private void advanceStage() {
        switch (this.stage) {
            case IDLE: {
                this.stage = State.GATHER_ENCHANTS;
                break;
            }
            case GATHER_ENCHANTS: {
                this.stage = State.GATHER_MANA;
                break;
            }
            case GATHER_MANA: {
                this.stage = State.DO_ENCHANT;
                break;
            }
            case DO_ENCHANT: {
                this.stage = State.RESET;
                this.stage3EndTicks = this.stageTicks;
                break;
            }
            case RESET: {
                this.stage = State.IDLE;
                this.stage3EndTicks = 0;
            }
        }
        this.stageTicks = 0;
        this.sync();
    }

    public boolean func_145842_c(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.func_174877_v().func_177958_n() + Math.random() * 0.4 - 0.2, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.enchanterEnchant, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.func_145842_c(event, param);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaRequired;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.manaRequired, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.manaRequired > 0;
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a(TAG_MANA_REQUIRED, this.manaRequired);
        cmp.func_74768_a(TAG_STAGE, this.stage.ordinal());
        cmp.func_74768_a(TAG_STAGE_TICKS, this.stageTicks);
        cmp.func_74768_a(TAG_STAGE_3_END_TICKS, this.stage3EndTicks);
        CompoundNBT itemCmp = new CompoundNBT();
        if (!this.itemToEnchant.func_190926_b()) {
            cmp.func_218657_a(TAG_ITEM, (INBT)this.itemToEnchant.func_77955_b(itemCmp));
        }
        String enchStr = this.enchants.stream().map(e -> ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)e.field_76302_b) + "=" + e.field_76303_c).collect(Collectors.joining(","));
        cmp.func_74778_a(TAG_ENCHANTS, enchStr);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.manaRequired = cmp.func_74762_e(TAG_MANA_REQUIRED);
        this.stage = State.values()[cmp.func_74762_e(TAG_STAGE)];
        this.stageTicks = cmp.func_74762_e(TAG_STAGE_TICKS);
        this.stage3EndTicks = cmp.func_74762_e(TAG_STAGE_3_END_TICKS);
        CompoundNBT itemCmp = cmp.func_74775_l(TAG_ITEM);
        this.itemToEnchant = ItemStack.func_199557_a((CompoundNBT)itemCmp);
        this.enchants.clear();
        String enchStr = cmp.func_74779_i(TAG_ENCHANTS);
        if (!enchStr.isEmpty()) {
            String[] enchTokens;
            for (String token : enchTokens = enchStr.split(",")) {
                try {
                    String[] entryTokens = token.split("=");
                    Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(entryTokens[0]));
                    int lvl = Integer.parseInt(entryTokens[1]);
                    if (ench == null) continue;
                    this.enchants.add(new EnchantmentData(ench, lvl));
                }
                catch (ResourceLocationException resourceLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean hasEnchantAlready(Enchantment enchant) {
        for (EnchantmentData data : this.enchants) {
            if (data.field_76302_b != enchant) continue;
            return true;
        }
        return false;
    }

    private boolean isEnchantmentValid(@Nullable Enchantment ench) {
        if (ench == null || !ench.func_92089_a(this.itemToEnchant)) {
            return false;
        }
        for (EnchantmentData data : this.enchants) {
            Enchantment otherEnch = data.field_76302_b;
            if (ench.func_191560_c(otherEnch)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Direction.Axis canEnchanterExist(World world, BlockPos pos) {
        Rotation rot = ((IMultiblock)MULTIBLOCK.func_179281_c()).validate(world, pos.func_177977_b());
        if (rot == null) {
            return null;
        }
        switch (rot) {
            default: {
                return Direction.Axis.Z;
            }
            case CLOCKWISE_90: 
            case COUNTERCLOCKWISE_90: 
        }
        return Direction.Axis.X;
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return this.stage == State.DO_ENCHANT;
    }

    @Override
    public int getAvailableSpaceForMana() {
        return Math.max(0, this.manaRequired - this.getCurrentMana());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD() {
        if (this.manaRequired > 0 && !this.itemToEnchant.func_190926_b()) {
            int x = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2 + 20;
            int y = Minecraft.func_71410_x().func_228018_at_().func_198087_p() / 2 - 8;
            RenderHelper.renderProgressPie(x, y, (float)this.mana / (float)this.manaRequired, this.itemToEnchant);
        }
    }

    static {
        PATTERN = new String[][]{{"_P_______P_", "___________", "___________", "P_________P", "___________", "___________", "_P_______P_"}, {"_F_______F_", "___________", "____F_F____", "F____L____F", "____F_F____", "___________", "_F_______F_"}, {"___________", "____BBB____", "___B_B_B___", "___BB0BB___", "___B_B_B___", "____BBB____", "___________"}};
        MULTIBLOCK = new LazyValue(() -> PatchouliAPI.instance.makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), ModBlocks.manaPylon, Character.valueOf('L'), Blocks.field_150368_y, Character.valueOf('B'), Blocks.field_150343_Z, Character.valueOf('0'), Blocks.field_150343_Z, Character.valueOf('F'), PatchouliAPI.instance.predicateMatcher(ModBlocks.whiteFlower, state -> state.func_177230_c().func_203417_a(ModTags.Blocks.MYSTICAL_FLOWERS))}));
        FORMED_MULTIBLOCK = new LazyValue(() -> PatchouliAPI.instance.makeMultiblock(PATTERN, new Object[]{Character.valueOf('P'), ModBlocks.manaPylon, Character.valueOf('L'), ModBlocks.enchanter, Character.valueOf('B'), Blocks.field_150343_Z, Character.valueOf('0'), Blocks.field_150343_Z, Character.valueOf('F'), PatchouliAPI.instance.predicateMatcher(ModBlocks.whiteFlower, state -> state.func_177230_c().func_203417_a(ModTags.Blocks.MYSTICAL_FLOWERS))}));
        PYLON_LOCATIONS = new EnumMap<Direction.Axis, BlockPos[]>(Direction.Axis.class);
        PYLON_LOCATIONS.put(Direction.Axis.X, new BlockPos[]{new BlockPos(-5, 1, 0), new BlockPos(5, 1, 0), new BlockPos(-4, 1, 3), new BlockPos(4, 1, 3), new BlockPos(-4, 1, -3), new BlockPos(4, 1, -3)});
        PYLON_LOCATIONS.put(Direction.Axis.Z, new BlockPos[]{new BlockPos(0, 1, -5), new BlockPos(0, 1, 5), new BlockPos(3, 1, -4), new BlockPos(3, 1, 4), new BlockPos(-3, 1, -4), new BlockPos(-3, 1, 4)});
    }

    public static enum State {
        IDLE,
        GATHER_ENCHANTS,
        GATHER_MANA,
        DO_ENCHANT,
        RESET;

    }
}

