/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;

public class BlockRuneAltar
extends BlockModWaterloggable
implements IWandable {
    private static final VoxelShape TOP = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)TOP, (VoxelShape)BOTTOM, (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public BlockRuneAltar(Block.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileRuneAltar altar = (TileRuneAltar)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (altar.manaToGet == 0) {
                InventoryHelper.withdrawFromInventory(altar, player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return ActionResultType.SUCCESS;
            }
        } else {
            if (altar.isEmpty() && stack.func_190926_b()) {
                altar.trySetLastRecipe(player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return ActionResultType.SUCCESS;
            }
            if (!stack.func_190926_b()) {
                boolean result = altar.addItem(player, stack, hand);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return result ? ActionResultType.SUCCESS : ActionResultType.PASS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileRuneAltar();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileRuneAltar altar = (TileRuneAltar)world.func_175625_s(pos);
        return altar.signal;
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        ((TileRuneAltar)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }
}

