/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.TileSparkChanger;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ItemSparkUpgrade;

public class BlockSparkChanger
extends BlockModWaterloggable {
    private static final VoxelShape SHAPE = BlockSparkChanger.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public BlockSparkChanger(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u});
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u);
        if (power && !powered) {
            ((TileSparkChanger)world.func_175625_s(pos)).doSwap();
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileSparkChanger changer = (TileSparkChanger)world.func_175625_s(pos);
        ItemStack pstack = player.func_184586_b(hand);
        ItemStack cstack = changer.getItemHandler().getStackInSlot(0);
        if (!cstack.func_190926_b()) {
            changer.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            world.func_175666_e(pos, (Block)this);
            changer.func_70296_d();
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)cstack);
            return ActionResultType.SUCCESS;
        }
        if (!pstack.func_190926_b() && pstack.func_77973_b() instanceof ItemSparkUpgrade) {
            changer.getItemHandler().setStackInSlot(0, pstack.func_77979_a(1));
            world.func_175666_e(pos, (Block)this);
            changer.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileSparkChanger changer = (TileSparkChanger)world.func_175625_s(pos);
        ItemStack stack = changer.getItemHandler().getStackInSlot(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSparkUpgrade) {
            return ((ItemSparkUpgrade)stack.func_77973_b()).type.ordinal() + 1;
        }
        return 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileSparkChanger();
    }
}

