/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;

public class AlfPortalBreadTrigger
implements ICriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("botania", "alf_portal_bread");
    public static final AlfPortalBreadTrigger INSTANCE = new AlfPortalBreadTrigger();
    private final Map<PlayerAdvancements, PlayerTracker> playerTrackers = new HashMap<PlayerAdvancements, PlayerTracker>();

    private AlfPortalBreadTrigger() {
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        this.playerTrackers.computeIfAbsent((PlayerAdvancements)player, (Function<PlayerAdvancements, PlayerTracker>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.advancements.PlayerAdvancements ), (Lnet/minecraft/advancements/PlayerAdvancements;)Lvazkii/botania/common/advancements/AlfPortalBreadTrigger$PlayerTracker;)()).listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements player, @Nonnull ICriterionTrigger.Listener<Instance> listener) {
        PlayerTracker tracker = this.playerTrackers.get(player);
        if (tracker != null) {
            tracker.listeners.remove(listener);
            if (tracker.listeners.isEmpty()) {
                this.playerTrackers.remove(player);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements player) {
        this.playerTrackers.remove(player);
    }

    @Nonnull
    public Instance deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return new Instance(LocationPredicate.func_193454_a((JsonElement)json.get("portal_location")));
    }

    public void trigger(ServerPlayerEntity player, BlockPos portal) {
        PlayerTracker tracker = this.playerTrackers.get(player.func_192039_O());
        if (tracker != null) {
            tracker.trigger(player.func_71121_q(), portal);
        }
    }

    static class Instance
    implements ICriterionInstance {
        private final LocationPredicate portal;

        Instance(LocationPredicate portal) {
            this.portal = portal;
        }

        @Nonnull
        public ResourceLocation func_192244_a() {
            return ID;
        }

        boolean test(ServerWorld world, BlockPos portal) {
            return this.portal.func_193453_a(world, (float)portal.func_177958_n(), (float)portal.func_177956_o(), (float)portal.func_177952_p());
        }
    }

    static class PlayerTracker {
        private final PlayerAdvancements playerAdvancements;
        final Set<ICriterionTrigger.Listener<Instance>> listeners = new HashSet<ICriterionTrigger.Listener<Instance>>();

        PlayerTracker(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void trigger(ServerWorld world, BlockPos portal) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(world, portal)) continue;
                list.add(listener);
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }
}

