/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class GunModel
implements IBakedModel {
    private static final ModelResourceLocation DESU = new ModelResourceLocation("botania:desu_gun", "inventory");
    private static final ModelResourceLocation DESU_CLIP = new ModelResourceLocation("botania:desu_gun_clip", "inventory");
    private final ModelBakery bakery;
    private final IBakedModel originalModel;
    private final IBakedModel originalModelClip;
    private final ItemOverrideList itemHandler = new ItemOverrideList(){

        @Nonnull
        public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            boolean clip = ItemManaGun.hasClip(stack);
            if (ItemManaGun.isSugoiKawaiiDesuNe(stack)) {
                return Minecraft.func_71410_x().func_209506_al().func_174953_a(clip ? DESU_CLIP : DESU);
            }
            ItemStack lens = ItemManaGun.getLens(stack);
            if (!lens.func_190926_b()) {
                return GunModel.this.getModel(lens, clip);
            }
            return clip ? GunModel.this.originalModelClip : GunModel.this.originalModel;
        }
    };
    private final HashMap<Pair<Item, Boolean>, CompositeBakedModel> cache = new HashMap();

    public GunModel(ModelBakery bakery, IBakedModel originalModel, IBakedModel originalModelClip) {
        this.bakery = bakery;
        this.originalModel = (IBakedModel)Preconditions.checkNotNull((Object)originalModel);
        this.originalModelClip = (IBakedModel)Preconditions.checkNotNull((Object)originalModelClip);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemHandler;
    }

    @Nonnull
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand) {
        return this.originalModel.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.originalModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.originalModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.originalModel.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.originalModel.func_177552_f();
    }

    public boolean func_230044_c_() {
        return this.originalModel.func_230044_c_();
    }

    private CompositeBakedModel getModel(ItemStack lens, boolean clip) {
        return this.cache.computeIfAbsent((Pair<Item, Boolean>)Pair.of((Object)lens.func_77973_b(), (Object)clip), p -> new CompositeBakedModel(this.bakery, lens, clip ? this.originalModelClip : this.originalModel));
    }

    private static class CompositeBakedModel
    extends BakedModelWrapper<IBakedModel> {
        private static final BlockModel MODEL_GENERATED = (BlockModel)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, null, (String)"field_177606_o");
        private final List<BakedQuad> genQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

        CompositeBakedModel(ModelBakery bakery, ItemStack lens, IBakedModel gun) {
            super(gun);
            IBakedModel lensBaked;
            IUnbakedModel lensUnbaked = bakery.func_209597_a((ResourceLocation)new ModelResourceLocation(lens.func_77973_b().getRegistryName(), "inventory"));
            SimpleModelTransform transform = new SimpleModelTransform(new TransformationMatrix(new Vector3f(-0.4f, 0.2f, 0.0f), Vector3f.field_229181_d_.func_229193_c_(1.5707964f), new Vector3f(0.625f, 0.625f, 0.625f), null));
            ResourceLocation name = ResourceLocationHelper.prefix("gun_with_" + lens.func_77973_b().getRegistryName().toString().replace(':', '_'));
            if (lensUnbaked instanceof BlockModel && ((BlockModel)lensUnbaked).func_178310_f() == MODEL_GENERATED) {
                Direction[] bm = (Direction[])lensUnbaked;
                lensBaked = new ItemModelGenerator().func_209579_a(ModelLoader.defaultTextureGetter(), (BlockModel)bm).func_228813_a_(bakery, (BlockModel)bm, ModelLoader.defaultTextureGetter(), (IModelTransform)transform, name, false);
            } else {
                lensBaked = lensUnbaked.func_225613_a_(bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)transform, name);
            }
            for (Direction e : Direction.values()) {
                this.faceQuads.put(e, new ArrayList());
            }
            Random rand = new Random(0L);
            this.genQuads.addAll(lensBaked.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(lensBaked.func_200117_a(null, e, rand));
            }
            rand.setSeed(0L);
            this.genQuads.addAll(gun.func_200117_a(null, null, rand));
            for (Direction e : Direction.values()) {
                rand.setSeed(0L);
                this.faceQuads.get(e).addAll(gun.func_200117_a(null, e, rand));
            }
        }

        @Nonnull
        public List<BakedQuad> func_200117_a(BlockState state, Direction face, @Nonnull Random rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        public IBakedModel handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType, MatrixStack stack) {
            super.handlePerspective(cameraTransformType, stack);
            return this;
        }
    }
}

