/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.patchouli.api.BookDrawScreenEvent;

@Mod.EventBusSubscriber(modid="botania", value={Dist.CLIENT})
public class KonamiHandler {
    private static final int[] KONAMI_CODE = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
    private static int nextLetter = 0;
    private static int konamiTime = 0;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent evt) {
        if (konamiTime > 0) {
            --konamiTime;
        }
        if (!ItemLexicon.isOpen()) {
            nextLetter = 0;
        }
    }

    @SubscribeEvent
    public static void handleInput(InputEvent.KeyInputEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (evt.getModifiers() == 0 && evt.getAction() == 1 && ItemLexicon.isOpen()) {
            if (konamiTime == 0 && evt.getKey() == KONAMI_CODE[nextLetter]) {
                if (++nextLetter >= KONAMI_CODE.length) {
                    mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)ModSounds.way, (float)1.0f));
                    nextLetter = 0;
                    konamiTime = 240;
                }
            } else {
                nextLetter = 0;
            }
        }
    }

    @SubscribeEvent
    public static void renderBook(BookDrawScreenEvent evt) {
        if (konamiTime > 0) {
            String meme = I18n.func_135052_a((String)"botania.subtitle.way", (Object[])new Object[0]);
            GlStateManager.func_227731_j_();
            GlStateManager.func_227626_N_();
            int fullWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(meme);
            int left = evt.gui.width;
            double widthPerTick = (fullWidth + evt.gui.width) / 240;
            double currWidth = (double)left - widthPerTick * (double)(240.0f - ((float)konamiTime - evt.partialTicks)) * 3.2;
            GlStateManager.func_227670_b_((double)currWidth, (double)(evt.gui.height / 2 - 10), (double)0.0);
            GlStateManager.func_227672_b_((float)4.0f, (float)4.0f, (float)4.0f);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(meme, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.func_227627_O_();
            GlStateManager.func_227734_k_();
        }
    }
}

