/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import com.mojang.blaze3d.matrix.MatrixStack;

import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.LivingEntity;

/**
 * A few helper methods for the render.
 */
public final class AccessoryRenderHelper {

	/**
	 * Rotates the render for a bauble correctly if the player is sneaking.
	 */
	public static void rotateIfSneaking(MatrixStack ms, LivingEntity player) {
		if (player.isCrouching()) {
			applySneakingRotation(ms);
		}
	}

	/**
	 * Rotates the render for a bauble correctly for a sneaking player.
	 */
	public static void applySneakingRotation(MatrixStack ms) {
		ms.translate(0F, 0.2F, 0F);
		ms.multiply(Vector3f.POSITIVE_X.getDegreesQuaternion(90F / (float) Math.PI));
	}

	/**
	 * Shifts the render for a bauble correctly to the head, including sneaking rotation.
	 */
	public static void translateToHeadLevel(MatrixStack ms, LivingEntity player, float partialTicks) {

		float yaw = player.prevRotationYawHead + (player.rotationYawHead - player.prevRotationYawHead) * partialTicks;
		float yawOffset = player.prevRenderYawOffset + (player.renderYawOffset - player.prevRenderYawOffset) * partialTicks;
		float pitch = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * partialTicks;

		ms.multiply(Vector3f.POSITIVE_Y.getDegreesQuaternion(-yawOffset));
		ms.multiply(Vector3f.POSITIVE_Y.getDegreesQuaternion(yaw - 270));
		ms.multiply(Vector3f.POSITIVE_Z.getDegreesQuaternion(pitch));

		ms.translate(0, -player.getEyeHeight(), 0);
//        if (player.shouldRenderSneaking()) TODO Sneaking needs a different adjustment now
//            GlStateManager.translatef(0.25F * MathHelper.sin(player.rotationPitch * (float) Math.PI / 180), 0.25F * MathHelper.cos(player.rotationPitch * (float) Math.PI / 180), 0F);
	}

}
