/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemSmeltRod
extends ItemMod
implements IManaUsingItem {
    private static final int TIME = 10;
    private static final int COST = 300;
    private static final int COST_PER_TICK = 30;
    public static final Map<PlayerEntity, SmeltData> playerData = new WeakHashMap<PlayerEntity, SmeltData>();

    public ItemSmeltRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack par1ItemStack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int time) {
        if (!(living instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity p = (PlayerEntity)living;
        Inventory dummyInv = new Inventory(1);
        if (!ManaItemHandler.requestManaExactForTool(stack, p, 30, false)) {
            return;
        }
        BlockRayTraceResult pos = ToolCommons.raytraceFromEntity((Entity)p, 32.0, false);
        if (pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockState state = p.field_70170_p.func_180495_p(pos.func_216350_a());
            dummyInv.func_70299_a(0, new ItemStack((IItemProvider)state.func_177230_c()));
            Optional<ItemStack> maybeResult = p.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)dummyInv, p.field_70170_p).map(arg_0 -> ItemSmeltRod.lambda$onUsingTick$0((IInventory)dummyInv, arg_0));
            if (maybeResult.isPresent() && !maybeResult.get().func_190926_b() && maybeResult.get().func_77973_b() instanceof BlockItem) {
                SmeltData data;
                ItemStack result = maybeResult.get();
                boolean decremented = false;
                if (playerData.containsKey(p) && (data = playerData.get(p)).equalPos(pos)) {
                    --data.progress;
                    decremented = true;
                    if (data.progress <= 0) {
                        if (!p.field_70170_p.field_72995_K) {
                            p.field_70170_p.func_175656_a(pos.func_216350_a(), Block.func_149634_a((Item)result.func_77973_b()).func_176223_P());
                            p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 0.6f, 1.0f);
                            p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            ManaItemHandler.requestManaExactForTool(stack, p, 30, true);
                            playerData.remove(p);
                            decremented = false;
                        }
                        WispParticleData data1 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        for (int i = 0; i < 25; ++i) {
                            double x = (double)pos.func_216350_a().func_177958_n() + Math.random();
                            double y = (double)pos.func_216350_a().func_177956_o() + Math.random();
                            double z = (double)pos.func_216350_a().func_177952_p() + Math.random();
                            p.field_70170_p.func_195594_a((IParticleData)data1, x, y, z, 0.0, (double)((float)(-Math.random()) / 10.0f), 0.0);
                        }
                    }
                }
                if (!decremented) {
                    playerData.put(p, new SmeltData(pos, IManaProficiencyArmor.Helper.hasProficiency(p, stack) ? 6 : 10));
                } else {
                    for (int i = 0; i < 2; ++i) {
                        double x = (double)pos.func_216350_a().func_177958_n() + Math.random();
                        double y = (double)pos.func_216350_a().func_177956_o() + Math.random();
                        double z = (double)pos.func_216350_a().func_177952_p() + Math.random();
                        WispParticleData data2 = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 1.0f);
                        p.field_70170_p.func_195594_a((IParticleData)data2, x, y, z, 0.0, (double)((float)Math.random() / 10.0f), 0.0);
                    }
                    if (time % 10 == 0) {
                        p.field_70170_p.func_184148_a(null, p.field_70165_t, p.field_70163_u, p.field_70161_v, SoundEvents.field_187643_bs, SoundCategory.PLAYERS, (float)Math.random() / 2.0f + 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private static /* synthetic */ ItemStack lambda$onUsingTick$0(IInventory dummyInv, FurnaceRecipe r) {
        return r.func_77572_b(dummyInv);
    }

    static class SmeltData {
        public final BlockRayTraceResult pos;
        public int progress;

        public SmeltData(BlockRayTraceResult pos, int progress) {
            this.pos = pos;
            this.progress = progress;
        }

        public boolean equalPos(BlockRayTraceResult pos) {
            return pos.func_216350_a().equals((Object)this.pos.func_216350_a());
        }
    }
}

