/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.item.ItemMod;

public class ItemMissileRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_missile.png");
    private static final int COST_PER = 120;
    private static final int COST_AVATAR = 40;

    public ItemMissileRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack par1ItemStack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (!(living instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)living;
        if (count != this.func_77626_a(stack) && count % (IManaProficiencyArmor.Helper.hasProficiency(player, stack) ? 1 : 2) == 0 && !player.field_70170_p.field_72995_K && ManaItemHandler.requestManaExactForTool(stack, player, 120, false)) {
            if (this.spawnMissile(player.field_70170_p, (LivingEntity)player, player.field_70165_t + (Math.random() - 0.05), player.field_70163_u + 2.4 + (Math.random() - 0.05), player.field_70161_v + (Math.random() - 0.05))) {
                ManaItemHandler.requestManaExactForTool(stack, player, 120, true);
            }
            SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
            player.field_70170_p.func_195594_a((IParticleData)data, player.field_70165_t, player.field_70163_u + 2.4, player.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    public boolean spawnMissile(World world, LivingEntity thrower, double x, double y, double z) {
        EntityMagicMissile missile = thrower != null ? new EntityMagicMissile(thrower, false) : new EntityMagicMissile(world);
        missile.func_70107_b(x, y, z);
        if (missile.findTarget()) {
            if (!world.field_72995_K) {
                missile.func_184185_a(ModSounds.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
                world.func_217376_c((Entity)missile);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (tile.getCurrentMana() >= 40 && tile.getElapsedFunctionalTicks() % 3 == 0 && tile.isEnabled() && this.spawnMissile(world, null, (double)te.func_174877_v().func_177958_n() + 0.5 + (Math.random() - 0.05), (double)te.func_174877_v().func_177956_o() + 2.5 + (Math.random() - 0.05), (double)te.func_174877_v().func_177952_p() + (Math.random() - 0.05))) {
            if (!world.field_72995_K) {
                tile.recieveMana(-40);
            }
            SparkleParticleData data = SparkleParticleData.sparkle(6.0f, 1.0f, 0.4f, 1.0f, 6);
            world.func_195594_a((IParticleData)data, (double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 2.5, (double)te.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

