/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.item.ModItems;

public class ItemRelic
extends ItemMod
implements IRelic {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemRelic(Item.Properties props) {
        super(props);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof PlayerEntity) {
            this.updateRelic(stack, (PlayerEntity)entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addBindInfo(List<ITextComponent> list, ItemStack stack) {
        if (Screen.hasShiftDown()) {
            if (!this.hasUUID(stack)) {
                list.add((ITextComponent)new TranslationTextComponent("botaniamisc.relicUnbound", new Object[0]));
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                list.add((ITextComponent)new TranslationTextComponent("botaniamisc.notYourSagittarius", new Object[0]));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("botaniamisc.relicSoulbound", new Object[]{Minecraft.func_71410_x().field_71439_g.func_200200_C_()}));
            }
            if (stack.func_77973_b() == ModItems.dice) {
                list.add((ITextComponent)new StringTextComponent(""));
                String name = stack.func_77977_a() + ".poem";
                for (int i = 0; i < 4; ++i) {
                    list.add(new TranslationTextComponent(name + i, new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
                }
            }
        } else {
            list.add((ITextComponent)new TranslationTextComponent("botaniamisc.shiftinfo", new Object[0]));
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public void updateRelic(ItemStack stack, PlayerEntity player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof ServerPlayerEntity) {
                RelicBindTrigger.INSTANCE.trigger((ServerPlayerEntity)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemRelic.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(PlayerEntity player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    @Override
    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString(stack, TAG_SOULBIND_UUID, uuid.toString());
    }

    @Override
    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance(stack, TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString(stack, TAG_SOULBIND_UUID, ""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry(stack, TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    @Override
    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public Rarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }
}

