/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.awt.Color;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.lens.Lens;

public class LensFlare
extends Lens {
    @Override
    public boolean allowBurstShooting(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        return false;
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        if (!redstone) {
            this.emitParticles(stack, spreader, redstone);
        }
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        this.emitParticles(stack, spreader, redstone);
    }

    private void emitParticles(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        float rotationYaw = -(spreader.getRotationX() + 90.0f);
        float rotationPitch = spreader.getRotationY();
        float f = 0.3f;
        float mx = (float)((double)(MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        float mz = (float)((double)(-(MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * f)) / 2.0);
        float my = (float)((double)(MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * f) / 2.0);
        int storedColor = ItemLens.getStoredColor(stack);
        int hex = -1;
        TileEntity tile = (TileEntity)spreader;
        if (storedColor == 16) {
            hex = Color.HSBtoRGB((float)(tile.func_145831_w().func_82737_E() * 2L % 360L) / 360.0f, 1.0f, 1.0f);
        } else if (storedColor >= 0) {
            hex = DyeColor.func_196056_a((int)storedColor).field_193351_w;
        }
        float r = (float)((hex & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((hex & 0xFF00) >> 8) / 255.0f;
        float b = (float)(hex & 0xFF) / 255.0f;
        WispParticleData data = WispParticleData.wisp(0.4f, r, g, b);
        tile.func_145831_w().func_195594_a((IParticleData)data, (double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, (double)mx, (double)my, (double)mz);
    }
}

