/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.curios;

import com.google.common.collect.Multimap;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.event.LivingCurioDropRulesEvent;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import vazkii.botania.common.capability.SimpleCapProvider;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class CurioIntegration
extends EquipmentHandler {
    @SubscribeEvent
    public static void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("charm"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("ring").setSize(2));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("belt"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("body"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("head"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("necklace"));
    }

    @SubscribeEvent
    public static void keepCurioDrops(LivingCurioDropRulesEvent event) {
        event.addOverride(stack -> {
            if (ItemKeepIvy.hasIvy(stack)) {
                stack.func_196083_e("Botania_keepIvy");
                return true;
            }
            return false;
        }, ICurio.DropRule.ALWAYS_KEEP);
    }

    @Override
    protected LazyOptional<IItemHandlerModifiable> getAllWornItems(LivingEntity living) {
        return CuriosAPI.getCuriosHandler((LivingEntity)living).map(h -> {
            IItemHandlerModifiable[] invs = h.getCurioMap().values().toArray(new IItemHandlerModifiable[0]);
            return new CombinedInvWrapper(invs);
        });
    }

    @Override
    protected ItemStack findItem(Item item, LivingEntity living) {
        return CuriosAPI.getCurioEquipped((Item)item, (LivingEntity)living).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
    }

    @Override
    protected ItemStack findItem(Predicate<ItemStack> pred, LivingEntity living) {
        return CuriosAPI.getCurioEquipped(pred, (LivingEntity)living).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
    }

    @Override
    protected ICapabilityProvider initCap(ItemStack stack) {
        return new SimpleCapProvider<Wrapper>(CuriosCapability.ITEM, new Wrapper(stack));
    }

    @Override
    public boolean isAccessory(ItemStack stack) {
        return super.isAccessory(stack) || stack.getCapability(CuriosCapability.ITEM).isPresent();
    }

    private static class Wrapper
    implements ICurio {
        private final ItemStack stack;

        Wrapper(ItemStack stack) {
            this.stack = stack;
        }

        private ItemBauble getItem() {
            return (ItemBauble)this.stack.func_77973_b();
        }

        public void onCurioTick(String identifier, LivingEntity entity) {
            this.getItem().onWornTick(this.stack, entity);
        }

        public void onEquipped(String identifier, LivingEntity entity) {
            this.getItem().onEquipped(this.stack, entity);
        }

        public void onUnequipped(String identifier, LivingEntity entity) {
            this.getItem().onUnequipped(this.stack, entity);
        }

        public boolean canEquip(String identifier, LivingEntity entity) {
            return this.getItem().canEquip(this.stack, entity);
        }

        public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
            return this.getItem().getEquippedAttributeModifiers(this.stack);
        }

        public boolean shouldSyncToTracking(String identifier, LivingEntity entity) {
            return true;
        }

        public void playEquipSound(LivingEntity entity) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.equipBauble, entity.func_184176_by(), 0.1f, 1.3f);
        }

        public boolean canRightClickEquip() {
            return true;
        }

        public boolean hasRender(String identifier, LivingEntity entity) {
            return this.getItem().hasRender(this.stack, entity);
        }

        public void doRender(String identifier, LivingEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.getItem().doRender(this.stack, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }
}

