/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class TileHourglass
extends TileSimpleInventory
implements ITickableTileEntity {
    @ObjectHolder(value="botania:hourglass")
    public static TileEntityType<TileHourglass> TYPE;
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    public TileHourglass() {
        super(TYPE);
    }

    private boolean isDust() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.manaPowder;
    }

    public void func_73660_a() {
        int totalTime = this.getTotalTime();
        boolean dust = this.isDust();
        if (totalTime > 0 || dust) {
            if (this.move && !dust) {
                ++this.time;
            }
            if (this.time >= totalTime) {
                this.time = 0;
                this.flip = !this.flip;
                this.flipTicks = 4;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 1);
                    this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), this.func_195044_w().func_177230_c().func_149738_a((IWorldReader)this.field_145850_b));
                }
                for (Direction facing : Direction.values()) {
                    BlockPos pos = this.func_174877_v().func_177972_a(facing);
                    BlockState state = this.field_145850_b.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof IHourglassTrigger)) continue;
                    ((IHourglassTrigger)state.func_177230_c()).onTriggeredByHourglass(this.field_145850_b, pos, this);
                }
            }
            this.lastFraction = this.timeFraction;
            this.timeFraction = (float)this.time / (float)totalTime;
        } else {
            this.time = 0;
            this.lastFraction = 0.0f;
            this.timeFraction = 0.0f;
        }
        if (this.flipTicks > 0) {
            --this.flipTicks;
        }
    }

    public void onManaCollide() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        return TileHourglass.getStackItemTime(stack) * stack.func_190916_E();
    }

    public static int getStackItemTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Blocks.field_150354_m.func_199767_j()) {
            return 20;
        }
        if (stack.func_77973_b() == Blocks.field_196611_F.func_199767_j()) {
            return 200;
        }
        if (stack.func_77973_b() == Blocks.field_150425_aM.func_199767_j()) {
            return 1200;
        }
        if (stack.func_77973_b() == ModItems.manaPowder) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Blocks.field_150354_m.func_199767_j()) {
            return 16772169;
        }
        if (stack.func_77973_b() == Blocks.field_196611_F.func_199767_j()) {
            return 15292416;
        }
        if (stack.func_77973_b() == Blocks.field_150425_aM.func_199767_j()) {
            return 5914927;
        }
        if (stack.func_77973_b() == ModItems.manaPowder) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, true){

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!(stack.func_190926_b() || stack.func_77973_b() != Blocks.field_150354_m.func_199767_j() && stack.func_77973_b() != Blocks.field_196611_F.func_199767_j() && stack.func_77973_b() != Blocks.field_150425_aM.func_199767_j() && stack.func_77973_b() != ModItems.manaPowder)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (!((TileHourglass)TileHourglass.this).field_145850_b.field_72995_K) {
                    TileHourglass.this.time = 0;
                    TileHourglass.this.timeFraction = 0.0f;
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(TileHourglass.this);
                }
            }
        };
    }

    @Override
    public void writePacketNBT(CompoundNBT par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_TIME, this.time);
        par1nbtTagCompound.func_74776_a(TAG_TIME_FRACTION, this.timeFraction);
        par1nbtTagCompound.func_74757_a(TAG_FLIP, this.flip);
        par1nbtTagCompound.func_74768_a(TAG_FLIP_TICKS, this.flipTicks);
        par1nbtTagCompound.func_74757_a(TAG_MOVE, this.move);
        par1nbtTagCompound.func_74757_a(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(CompoundNBT par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.time = par1nbtTagCompound.func_74762_e(TAG_TIME);
        this.timeFraction = par1nbtTagCompound.func_74760_g(TAG_TIME_FRACTION);
        this.flip = par1nbtTagCompound.func_74767_n(TAG_FLIP);
        this.flipTicks = par1nbtTagCompound.func_74762_e(TAG_FLIP_TICKS);
        this.move = par1nbtTagCompound.func_74767_n(TAG_MOVE);
        this.lock = par1nbtTagCompound.func_74767_n(TAG_LOCK);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD() {
        Minecraft mc = Minecraft.func_71410_x();
        int x = mc.field_195558_d.func_198107_o() / 2 + 10;
        int y = mc.field_195558_d.func_198087_p() / 2 - 10;
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            RenderHelper.func_74520_c();
            GlStateManager.enableRescaleNormal();
            mc.func_175599_af().func_175042_a(stack, x, y);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, stack, x, y);
            GlStateManager.disableRescaleNormal();
            RenderHelper.func_74518_a();
            int time = this.getTotalTime();
            String timeStr = StringUtils.func_76337_a((int)time);
            mc.field_71466_p.func_175063_a(timeStr, (float)(x + 20), (float)y, this.getColor());
            String status = "";
            if (this.lock) {
                status = "locked";
            }
            if (!this.move) {
                String string = status = status.isEmpty() ? "stopped" : "lockedStopped";
            }
            if (!status.isEmpty()) {
                mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)("botaniamisc." + status), (Object[])new Object[0]), (float)(x + 20), (float)(y + 12), this.getColor());
            }
        }
    }
}

