/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;

public class SubTileGourmaryllis
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:gourmaryllis")
    public static TileEntityType<SubTileGourmaryllis> TYPE;
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_DIGESTING_MANA = "digestingMana";
    public static final String TAG_LAST_FOOD = "lastFood";
    public static final String TAG_LAST_FOOD_COUNT = "lastFoodCount";
    private static final int RANGE = 1;
    private int cooldown = 0;
    private int digestingMana = 0;
    private ItemStack lastFood = ItemStack.field_190927_a;
    private int lastFoodCount = 0;

    public SubTileGourmaryllis() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.cooldown > -1) {
            --this.cooldown;
        }
        if (this.digestingMana != 0) {
            int munchInterval = 2 + 2 * this.lastFoodCount;
            if (this.cooldown == 0) {
                this.addMana(this.digestingMana);
                this.digestingMana = 0;
                float burpPitch = 1.0f - (float)(this.lastFoodCount - 1) * 0.05f;
                this.func_145831_w().func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187739_dZ, SoundCategory.BLOCKS, 1.0f, burpPitch);
                this.sync();
            } else if (this.cooldown % munchInterval == 0) {
                this.func_145831_w().func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187537_bA, SoundCategory.BLOCKS, 0.5f, 1.0f);
                Vec3d offset = this.func_145831_w().func_180495_p(this.getEffectivePos()).func_191059_e((IBlockReader)this.func_145831_w(), this.getEffectivePos()).func_72441_c(0.4, 0.6, 0.4);
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.lastFood), (double)this.getEffectivePos().func_177958_n() + offset.field_72450_a, (double)this.getEffectivePos().func_177956_o() + offset.field_72448_b, (double)this.getEffectivePos().func_177952_p() + offset.field_72449_c, 10, 0.1, 0.1, 0.1, 0.03);
            }
        }
        int slowdown = this.getSlowdownFactor();
        List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-1, -1, -1), this.getEffectivePos().func_177982_a(2, 2, 2)));
        for (ItemEntity item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r() || item.field_70128_L || item.field_70292_b < slowdown) continue;
            if (this.cooldown <= 0) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.lastFood, (ItemStack)stack)) {
                    ++this.lastFoodCount;
                } else {
                    this.lastFood = stack.func_77946_l();
                    this.lastFood.func_190920_e(1);
                    this.lastFoodCount = 1;
                }
                int val = Math.min(12, stack.func_77973_b().func_219967_s().func_221466_a());
                this.digestingMana = val * val * 70;
                this.digestingMana = (int)((float)this.digestingMana * (1.0f / (float)this.lastFoodCount));
                this.cooldown = val * 10;
                item.func_184185_a(SoundEvents.field_187537_bA, 0.2f, 0.6f);
                this.sync();
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), item.field_70165_t, item.field_70163_u, item.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05);
            }
            item.func_70106_y();
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
        cmp.func_74768_a(TAG_DIGESTING_MANA, this.digestingMana);
        cmp.func_218657_a(TAG_LAST_FOOD, (INBT)this.lastFood.func_77955_b(new CompoundNBT()));
        cmp.func_74768_a(TAG_LAST_FOOD_COUNT, this.lastFoodCount);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
        this.digestingMana = cmp.func_74762_e(TAG_DIGESTING_MANA);
        this.lastFood = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l(TAG_LAST_FOOD));
        this.lastFoodCount = cmp.func_74762_e(TAG_LAST_FOOD_COUNT);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 9000;
    }

    @Override
    public int getColor() {
        return 13882884;
    }
}

