/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;

public class SubTileSolegnolia
extends TileEntityFunctionalFlower {
    @ObjectHolder(value="botania:solegnolia")
    public static TileEntityType<SubTileSolegnolia> TYPE;
    private static final double RANGE = 5.0;
    private static final double RANGE_MINI = 1.0;
    private static final Set<SubTileSolegnolia> existingFlowers;

    public SubTileSolegnolia(TileEntityType<?> type) {
        super(type);
    }

    public SubTileSolegnolia() {
        this(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!existingFlowers.contains(this)) {
            existingFlowers.add(this);
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public static boolean hasSolegnoliaAround(Entity e) {
        return existingFlowers.stream().filter(f -> f.redstoneSignal == 0).filter(f -> f.func_145831_w() == e.field_70170_p).anyMatch(f -> f.getEffectivePos().func_218140_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, false) <= f.getRange() * f.getRange());
    }

    @Override
    public int getMaxMana() {
        return 1;
    }

    @Override
    public int getColor() {
        return 13212749;
    }

    public double getRange() {
        return 5.0;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    static {
        existingFlowers = Collections.newSetFromMap(new MapMaker().concurrencyLevel(2).weakKeys().makeMap());
    }

    public static class Mini
    extends SubTileSolegnolia {
        @ObjectHolder(value="botania:solegnolia_chibi")
        public static TileEntityType<Mini> TYPE;

        public Mini() {
            super(TYPE);
        }

        @Override
        public double getRange() {
            return 1.0;
        }
    }
}

