/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.item.ModItems;

public class BlockEnchanter
extends BlockMod
implements IWandable,
IWandHUD {
    public BlockEnchanter(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)Direction.Axis.X));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BotaniaStateProps.ENCHANTER_DIRECTION});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileEnchanter();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean stackEnchantable;
        TileEnchanter enchanter = (TileEnchanter)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.twigWand) {
            return false;
        }
        boolean bl = stackEnchantable = !stack.func_190926_b() && stack.func_77973_b() != Items.field_151122_aG && stack.func_77956_u() && stack.func_190916_E() == 1;
        if (enchanter.itemToEnchant.func_190926_b()) {
            if (!stackEnchantable) return false;
            enchanter.itemToEnchant = stack.func_77946_l();
            player.func_184611_a(hand, ItemStack.field_190927_a);
            enchanter.sync();
            return true;
        } else {
            if (enchanter.stage != TileEnchanter.State.IDLE) return true;
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)enchanter.itemToEnchant.func_77946_l());
            enchanter.itemToEnchant = ItemStack.field_190927_a;
            enchanter.sync();
        }
        return true;
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEnchanter enchanter = (TileEnchanter)world.func_175625_s(pos);
            if (!enchanter.itemToEnchant.func_190926_b()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), enchanter.itemToEnchant));
            }
            world.func_175666_e(pos, state.func_177230_c());
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        ((TileEnchanter)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        ((TileEnchanter)world.func_175625_s(pos)).renderHUD();
    }
}

