/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import vazkii.botania.common.block.tile.TileStarfield;

public class RenderTileStarfield
extends TileEntityRenderer<TileStarfield> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(TileStarfield tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getMatrix((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.getMatrix((int)2983, (FloatBuffer)PROJECTION);
        double d0 = x * x + y * y + z * z;
        int i = this.getPasses(d0);
        float f = this.getOffset();
        boolean flag = false;
        for (int j = 0; j < i; ++j) {
            GlStateManager.pushMatrix();
            float f1 = 2.0f / (float)(18 - j);
            if (j == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f1 = 0.15f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
                flag = true;
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            GlStateManager.translatef((float)(17.0f / f2), (float)((2.0f + f2 / 1.5f) * ((float)Util.func_211177_b() % 800000.0f / 800000.0f)), (float)0.0f);
            GlStateManager.rotatef((float)((f2 * f2 * 4321.0f + f2 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scalef((float)(4.5f - f2 / 4.0f), (float)(4.5f - f2 / 4.0f), (float)1.0f);
            GlStateManager.multMatrix((FloatBuffer)PROJECTION);
            GlStateManager.multMatrix((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f1;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f1;
            float f5 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f1;
            Color color = Color.getHSBColor((float)Util.func_211177_b() / 20.0f % 360.0f / 360.0f, 1.0f, 1.0f);
            f3 = (float)color.getRed() / 255.0f;
            f4 = (float)color.getGreen() / 255.0f;
            f5 = (float)color.getBlue() / 255.0f;
            bufferbuilder.func_181662_b(x, y + (double)f, z + 1.0).func_181666_a(f3 *= f1, f4 *= f1, f5 *= f1, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x, y + (double)f, z).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        if (flag) {
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        }
    }

    private int getPasses(double p_191286_1_) {
        int i = p_191286_1_ > 36864.0 ? 1 : (p_191286_1_ > 25600.0 ? 3 : (p_191286_1_ > 16384.0 ? 5 : (p_191286_1_ > 9216.0 ? 7 : (p_191286_1_ > 4096.0 ? 9 : (p_191286_1_ > 1024.0 ? 11 : (p_191286_1_ > 576.0 ? 13 : (p_191286_1_ > 256.0 ? 14 : 15)))))));
        return i;
    }

    private float getOffset() {
        return 0.24f;
    }

    private FloatBuffer getBuffer(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }
}

