/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.petalapothecary;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.common.block.ModBlocks;

public class PetalApothecaryRecipeCategory
implements IRecipeCategory<RecipePetals> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "petals");
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;

    public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 110);
        this.localizedName = I18n.func_135052_a((String)"botania.nei.petalApothecary", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/petal_overlay.png"), 0, 0, 150, 110);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.defaultAltar));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends RecipePetals> getRecipeClass() {
        return RecipePetals.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RecipePetals recipe, IIngredients iIngredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.getInputs()) {
            list.add(Arrays.asList(ingr.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, list);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void draw(RecipePetals recipe, double mouseX, double mouseY) {
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        this.overlay.draw();
        GlStateManager.disableBlend();
        GlStateManager.disableAlphaTest();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipePetals recipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 64, 52);
        recipeLayout.getItemStacks().set(0, new ItemStack((IItemProvider)ModBlocks.defaultAltar));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Point point = new Point(64, 20);
        Point center = new Point(64, 52);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, point.x, point.y);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            point = this.rotatePointAbout(point, center, angleBetweenEach);
        }
        recipeLayout.getItemStacks().init(index, false, 103, 17);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    private Point rotatePointAbout(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }
}

