/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelShovel
extends ShovelItem
implements IManaUsingItem,
ISortableTool {
    protected static final Map<Block, BlockState> HOE_LOOKUP = (Map)ObfuscationReflectionHelper.getPrivateValue(HoeItem.class, null, (String)"field_195973_b");
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelShovel(Item.Properties props) {
        this(BotaniaAPI.MANASTEEL_ITEM_TIER, props);
    }

    public ItemManasteelShovel(IItemTier mat, Item.Properties props) {
        super(mat, 1.5f, -3.0f, props);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, LivingEntity par2EntityLivingBase, @Nonnull LivingEntity par3EntityLivingBase) {
        ToolCommons.damageItem(par1ItemStack, 1, par3EntityLivingBase, this.getManaPerDamage());
        return true;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, this.getManaPerDamage());
    }

    public int getManaPerDamage() {
        return 60;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (super.func_195939_a(ctx) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (player == null || !player.func_175151_a(pos, ctx.func_196000_l(), stack)) {
            return ActionResultType.PASS;
        }
        UseHoeEvent event = new UseHoeEvent(ctx);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return ActionResultType.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            ToolCommons.damageItem(stack, 1, (LivingEntity)player, this.getManaPerDamage());
            return ActionResultType.SUCCESS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        BlockState converted = HOE_LOOKUP.get(block);
        if (converted == null) {
            return ActionResultType.PASS;
        }
        if (ctx.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a())) {
            world.func_184133_a(null, pos, converted.func_215695_r().func_185844_d(), SoundCategory.BLOCKS, (converted.func_215695_r().func_185843_a() + 1.0f) / 2.0f, converted.func_215695_r().func_185847_b() * 0.8f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            world.func_175656_a(pos, converted);
            ToolCommons.damageItem(stack, 1, (LivingEntity)player, this.getManaPerDamage());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof PlayerEntity && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (PlayerEntity)player, this.getManaPerDamage() * 2, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.SHOVEL;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }
}

