/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;

public class ItemTerrasteelHelm
extends ItemTerrasteelArmor
implements IManaDiscountArmor,
IAncientWillContainer,
IManaGivingItem {
    public static final String TAG_ANCIENT_WILL = "AncientWill";

    public ItemTerrasteelHelm(Item.Properties props) {
        super(EquipmentSlotType.HEAD, props);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityAttacked);
    }

    @Override
    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (!world.field_72995_K && this.hasArmorSet(player)) {
            int food = player.func_71024_bL().func_75116_a();
            if (food > 0 && food < 18 && player.func_70996_bM() && player.field_70173_aa % 80 == 0) {
                player.func_70691_i(1.0f);
            }
            ManaItemHandler.dispatchManaExact(stack, player, 1, true);
        }
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, PlayerEntity player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        ItemNBTHelper.setBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), true);
    }

    @Override
    public boolean hasAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemTerrasteelHelm.hasAncientWill_(stack, will);
    }

    private static boolean hasAncientWill_(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemNBTHelper.getBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        super.addArmorSetDescription(stack, list);
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, type)) continue;
            list.add(new TranslationTextComponent("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    private static boolean hasAnyWill(ItemStack stack) {
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!ItemTerrasteelHelm.hasAncientWill_(stack, type)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOnPlayer(ItemStack stack, PlayerEntity player, float partialTicks) {
        if (ItemTerrasteelHelm.hasAnyWill(stack) && !((ItemTerrasteelArmor)stack.func_77973_b()).hasPhantomInk(stack)) {
            GlStateManager.pushMatrix();
            float f = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94209_e();
            float f1 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94212_f();
            float f2 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94206_g();
            float f3 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94210_h();
            AccessoryRenderHelper.translateToHeadLevel((LivingEntity)player, partialTicks);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.26f, (float)-1.45f, (float)-0.39f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94211_a(), MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94216_b(), 0.0625f);
            GlStateManager.popMatrix();
        }
    }

    private void onEntityAttacked(LivingHurtEvent event) {
        PlayerEntity player;
        Entity attacker = event.getSource().func_76364_f();
        if (attacker instanceof PlayerEntity && this.hasArmorSet(player = (PlayerEntity)attacker)) {
            boolean crit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH();
            ItemStack stack = player.func_184582_a(EquipmentSlotType.HEAD);
            if (crit && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemTerrasteelHelm) {
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.AHRIM)) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76437_t, 20, 1));
                }
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.DHAROK)) {
                    event.setAmount(event.getAmount() * (1.0f + (1.0f - player.func_110143_aJ() / player.func_110138_aP()) * 0.5f));
                }
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.GUTHAN)) {
                    player.func_70691_i(event.getAmount() * 0.25f);
                }
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.TORAG)) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1));
                }
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.VERAC)) {
                    event.getSource().func_76348_h();
                }
                if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.KARIL)) {
                    event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_82731_v, 60, 1));
                }
            }
        }
    }
}

