/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityThornChakram
extends ThrowableEntity
implements IRendersAsItem {
    @ObjectHolder(value="botania:thorn_chakram")
    public static EntityType<EntityThornChakram> TYPE;
    private static final DataParameter<Integer> BOUNCES;
    private static final DataParameter<Boolean> FLARE;
    private static final DataParameter<Integer> RETURN_TO;
    private static final int MAX_BOUNCES = 16;
    private boolean bounced = false;
    private ItemStack stack = ItemStack.field_190927_a;

    public EntityThornChakram(EntityType<EntityThornChakram> type, World world) {
        super(type, world);
    }

    public EntityThornChakram(LivingEntity e, World world, ItemStack stack) {
        super(TYPE, e, world);
        this.stack = stack.func_77946_l();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(FLARE, (Object)false);
        this.field_70180_af.func_187214_a(RETURN_TO, (Object)-1);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        LivingEntity thrower;
        Vec3d old = this.func_213322_ci();
        super.func_70071_h_();
        if (!this.bounced) {
            this.func_213317_d(old);
        }
        this.bounced = false;
        if (this.isReturning() && (thrower = this.func_85052_h()) != null) {
            Vector3 motion = Vector3.fromEntityCenter((Entity)thrower).subtract(Vector3.fromEntityCenter((Entity)this)).normalize();
            this.func_213317_d(motion.toVec3D());
        }
        if (this.field_70170_p.field_72995_K && this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + r * (Math.random() - 0.5), this.field_70163_u + r * (Math.random() - 0.5), this.field_70161_v + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5));
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.getTimesBounced() < 16 && this.field_70173_aa <= 60)) {
            thrower = this.func_85052_h();
            if (thrower == null) {
                this.dropAndKill();
            } else {
                this.setEntityToReturnTo(thrower.func_145782_y());
                if (this.func_70068_e((Entity)thrower) < 2.0) {
                    this.dropAndKill();
                }
            }
        }
    }

    private void dropAndKill() {
        ItemStack stack = this.getItemStack();
        ItemEntity item = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_217376_c((Entity)item);
        this.func_70106_y();
    }

    private ItemStack getItemStack() {
        return !this.stack.func_190926_b() ? this.stack.func_77946_l() : (this.isFire() ? new ItemStack((IItemProvider)ModItems.flareChakram) : new ItemStack((IItemProvider)ModItems.thornChakram));
    }

    protected void func_70184_a(@Nonnull RayTraceResult pos) {
        if (this.isReturning()) {
            return;
        }
        switch (pos.func_216346_c()) {
            case BLOCK: {
                BlockRayTraceResult rtr = (BlockRayTraceResult)pos;
                Block block = this.field_70170_p.func_180495_p(rtr.func_216350_a()).func_177230_c();
                if (block instanceof BushBlock || block instanceof LeavesBlock) {
                    return;
                }
                int bounces = this.getTimesBounced();
                if (bounces >= 16) break;
                Vector3 currentMovementVec = new Vector3(this.func_213322_ci());
                Direction dir = rtr.func_216354_b();
                Vector3 normalVector = new Vector3(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()).normalize();
                Vector3 movementVec = normalVector.multiply(-2.0 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);
                this.func_213317_d(movementVec.toVec3D());
                this.bounced = true;
                if (this.field_70170_p.field_72995_K) break;
                this.setTimesBounced(this.getTimesBounced() + 1);
                break;
            }
            case ENTITY: {
                EntityRayTraceResult rtr = (EntityRayTraceResult)pos;
                if (this.field_70170_p.field_72995_K || !(rtr.func_216348_a() instanceof LivingEntity) || rtr.func_216348_a() == this.func_85052_h()) break;
                LivingEntity thrower = this.func_85052_h();
                rtr.func_216348_a().func_70097_a(thrower != null ? (thrower instanceof PlayerEntity ? DamageSource.func_76356_a((Entity)this, (Entity)thrower) : DamageSource.func_76358_a((LivingEntity)thrower)) : DamageSource.field_76377_j, 12.0f);
                if (this.isFire()) {
                    rtr.func_216348_a().func_70015_d(5);
                    break;
                }
                if (this.field_70170_p.field_73012_v.nextInt(3) != 0) break;
                ((LivingEntity)rtr.func_216348_a()).func_195064_c(new EffectInstance(Effects.field_76436_u, 60, 0));
                break;
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    private int getTimesBounced() {
        return (Integer)this.field_70180_af.func_187225_a(BOUNCES);
    }

    private void setTimesBounced(int times) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FLARE);
    }

    public void setFire(boolean fire) {
        this.field_70180_af.func_187227_b(FLARE, (Object)fire);
    }

    private boolean isReturning() {
        return this.getEntityToReturnTo() > -1;
    }

    private int getEntityToReturnTo() {
        return (Integer)this.field_70180_af.func_187225_a(RETURN_TO);
    }

    private void setEntityToReturnTo(int entityID) {
        this.field_70180_af.func_187227_b(RETURN_TO, (Object)entityID);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (!this.stack.func_190926_b()) {
            compound.func_218657_a("fly_stack", (INBT)this.stack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("flare", this.isFire());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fly_stack")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("fly_stack"));
        }
        this.setFire(compound.func_74767_n("flare"));
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return this.getItemStack();
    }

    static {
        BOUNCES = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187192_b);
        FLARE = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187198_h);
        RETURN_TO = EntityDataManager.func_187226_a(EntityThornChakram.class, (IDataSerializer)DataSerializers.field_187192_b);
    }
}

