/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.material.ItemDye;

public class EntityCorporeaSpark
extends EntitySparkBase
implements ICorporeaSpark {
    @ObjectHolder(value="botania:corporea_spark")
    public static EntityType<EntityCorporeaSpark> TYPE;
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final DataParameter<Boolean> MASTER;
    private static final DataParameter<Integer> ITEM_DISPLAY_TICKS;
    private static final DataParameter<ItemStack> DISPLAY_STACK;
    private ICorporeaSpark master;
    private List<ICorporeaSpark> connections = new ArrayList<ICorporeaSpark>();
    private List<ICorporeaSpark> relatives = new ArrayList<ICorporeaSpark>();
    private boolean firstTick = true;

    public EntityCorporeaSpark(EntityType<EntityCorporeaSpark> type, World world) {
        super(type, world);
    }

    public EntityCorporeaSpark(World world) {
        this(TYPE, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MASTER, (Object)false);
        this.field_70180_af.func_187214_a(ITEM_DISPLAY_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DISPLAY_STACK, (Object)ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.isMaster() ? new ItemStack((IItemProvider)ModItems.corporeaSparkMaster) : new ItemStack((IItemProvider)ModItems.corporeaSpark);
    }

    public void func_70071_h_() {
        int displayTicks;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        InvWithLocation inv = this.getSparkInventory();
        if (inv == null) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (this.master != null && (((Entity)this.master).field_70128_L || this.master.getNetwork() != this.getNetwork())) {
            this.master = null;
        }
        if ((displayTicks = this.getItemDisplayTicks()) > 0) {
            this.setItemDisplayTicks(displayTicks - 1);
        } else if (displayTicks < 0) {
            this.setItemDisplayTicks(displayTicks + 1);
        }
    }

    private void dropAndKill() {
        this.func_70099_a(new ItemStack((IItemProvider)(this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark)), 0.0f);
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
        this.relatives.clear();
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || connections.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || ((Entity)spark).field_70128_L) continue;
            connections.add(spark);
            this.relatives.add(spark);
            spark.registerConnections(master, this, connections);
        }
        this.master = master;
        this.connections = connections;
    }

    private List<ICorporeaSpark> getNearbySparks() {
        return this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(this.field_70165_t - 8.0, this.field_70163_u - 8.0, this.field_70161_v - 8.0, this.field_70165_t + 8.0, this.field_70163_u + 8.0, this.field_70161_v + 8.0), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new ArrayList<ICorporeaSpark>();
        this.relatives = new ArrayList<ICorporeaSpark>();
        if (this.master != null) {
            ICorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.registerConnections(oldMaster, this, new ArrayList<ICorporeaSpark>());
        }
    }

    private void findNetwork() {
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            ICorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || ((Entity)spark).field_70128_L || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(PlayerEntity player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<ICorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            EntitySpark.particleBeam(player, (Entity)spark, (Entity)spark.getMaster());
        } else {
            for (ICorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                EntitySpark.particleBeam(player, (Entity)spark, (Entity)endSpark);
                checked.add(endSpark);
                EntityCorporeaSpark.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public InvWithLocation getSparkInventory() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0));
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        return InventoryHelper.getInventoryWithLocation(this.field_70170_p, new BlockPos(x, y, z), Direction.UP);
    }

    @Override
    public List<ICorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<ICorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        this.setItemDisplayTicks(10);
        this.setDisplayedItem(stack);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            this.setItemDisplayTicks(-10);
            this.setDisplayedItem(stacks.get(0));
        }
    }

    @Override
    public ICorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.field_70180_af.func_187227_b(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.field_70180_af.func_187225_a(MASTER);
    }

    public int getItemDisplayTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ITEM_DISPLAY_TICKS);
    }

    public void setItemDisplayTicks(int ticks) {
        this.field_70180_af.func_187227_b(ITEM_DISPLAY_TICKS, (Object)ticks);
    }

    public ItemStack getDisplayedItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(DISPLAY_STACK);
    }

    public void setDisplayedItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(DISPLAY_STACK, (Object)stack);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70128_L && !stack.func_190926_b()) {
            if (player.field_70170_p.field_72995_K) {
                boolean valid;
                boolean bl = valid = stack.func_77973_b() == ModItems.twigWand || stack.func_77973_b() instanceof ItemDye || stack.func_77973_b() == ModItems.phantomInk;
                if (valid) {
                    player.func_184609_a(hand);
                }
                return valid;
            }
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (player.func_70093_af()) {
                    this.dropAndKill();
                    if (this.isMaster()) {
                        this.restartNetwork();
                    }
                } else {
                    EntityCorporeaSpark.displayRelatives(player, new ArrayList<ICorporeaSpark>(), this.master);
                }
                return true;
            }
            if (stack.func_77973_b() instanceof ItemDye) {
                DyeColor color = ((ItemDye)stack.func_77973_b()).color;
                if (color != this.getNetwork()) {
                    this.setNetwork(color);
                    if (this.isMaster()) {
                        this.restartNetwork();
                    } else {
                        this.findNetwork();
                    }
                    stack.func_190918_g(1);
                    return true;
                }
            } else if (stack.func_77973_b() == ModItems.phantomInk) {
                this.func_82142_c(true);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void func_70037_a(@Nonnull CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setMaster(cmp.func_74767_n(TAG_MASTER));
    }

    @Override
    protected void func_213281_b(@Nonnull CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74757_a(TAG_MASTER, this.isMaster());
    }

    static {
        MASTER = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (IDataSerializer)DataSerializers.field_187198_h);
        ITEM_DISPLAY_TICKS = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (IDataSerializer)DataSerializers.field_187192_b);
        DISPLAY_STACK = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (IDataSerializer)DataSerializers.field_187196_f);
    }
}

