/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class TileAvatar
extends TileSimpleInventory
implements IAvatarTile,
ITickableTileEntity {
    @ObjectHolder(value="botania:avatar")
    public static TileEntityType<TileAvatar> TYPE;
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "ticksElapsed";
    private boolean enabled;
    private int ticksElapsed;
    private int mana;

    public TileAvatar() {
        super(TYPE);
    }

    public void func_73660_a() {
        ItemStack stack;
        this.enabled = true;
        for (Direction dir : Direction.values()) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            this.enabled = false;
            break;
        }
        if (!(stack = this.itemHandler.getStackInSlot(0)).func_190926_b() && stack.func_77973_b() instanceof IAvatarWieldable) {
            IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
            wieldable.onAvatarUpdate(this, stack);
        }
        if (this.enabled) {
            ++this.ticksElapsed;
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a(TAG_ENABLED, this.enabled);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.ticksElapsed);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.mana);
    }

    @Override
    public void readPacketNBT(CompoundNBT par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.enabled = par1nbtTagCompound.func_74767_n(TAG_ENABLED);
        this.ticksElapsed = par1nbtTagCompound.func_74762_e("ticksElapsed");
        this.mana = par1nbtTagCompound.func_74762_e("ticksElapsed");
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(6400, this.mana + mana);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return !this.itemHandler.getStackInSlot(0).func_190926_b();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public IItemHandler getInventory() {
        return this.getItemHandler();
    }

    @Override
    public Direction getAvatarFacing() {
        return (Direction)this.func_195044_w().func_177229_b(BotaniaStateProps.CARDINALS);
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

