/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IPetalApothecary;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ModSounds;

public class TileAltar
extends TileSimpleInventory
implements IPetalApothecary,
ITickableTileEntity {
    @ObjectHolder(value="botania:altar")
    public static TileEntityType<TileAltar> TYPE;
    private static final Pattern SEED_PATTERN;
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    private static final String TAG_FLUID = "fluid";
    private static final String ITEM_TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";
    private Fluid fluid = Fluids.field_204541_a;
    private List<ItemStack> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public TileAltar() {
        super(TYPE);
    }

    public boolean collideEntityItem(ItemEntity item) {
        block14: {
            boolean hasFluidCapability;
            ItemStack stack;
            block13: {
                stack = item.func_92059_d();
                if (this.field_145850_b.field_72995_K || stack.func_190926_b() || !item.func_70089_S()) {
                    return false;
                }
                if (this.func_195044_w().func_177230_c() == ModBlocks.defaultAltar && stack.func_77973_b() == Blocks.field_150395_bd.func_199767_j()) {
                    CompoundNBT tmp = new CompoundNBT();
                    this.writePacketNBT(tmp);
                    stack.func_190918_g(1);
                    this.field_145850_b.func_175656_a(this.func_174877_v(), ModBlocks.mossyAltar.func_176223_P());
                    TileEntity newAltar = this.field_145850_b.func_175625_s(this.func_174877_v());
                    if (newAltar instanceof TileAltar) {
                        ((TileAltar)newAltar).readPacketNBT(tmp);
                    }
                    return true;
                }
                hasFluidCapability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
                if (this.getFluid() == Fluids.field_204541_a) {
                    if (stack.func_77973_b() instanceof FishBucketItem && ((FishBucketItem)stack.func_77973_b()).getFluid() == Fluids.field_204546_a) {
                        this.setFluid((Fluid)Fluids.field_204546_a);
                        ((FishBucketItem)stack.func_77973_b()).func_203792_a(this.field_145850_b, stack, this.func_174877_v().func_177984_a());
                        item.func_92058_a(new ItemStack((IItemProvider)Items.field_151133_ar));
                        return true;
                    }
                    if (hasFluidCapability) {
                        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseThrow(NullPointerException::new);
                        FluidStack drainWater = fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE);
                        FluidStack drainLava = fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.SIMULATE);
                        if (!drainWater.isEmpty() && drainWater.getFluid() == Fluids.field_204546_a && drainWater.getAmount() == 1000) {
                            this.setFluid((Fluid)Fluids.field_204546_a);
                            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                            fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                            item.func_92058_a(fluidHandler.getContainer());
                            return true;
                        }
                        if (!drainLava.isEmpty() && drainLava.getFluid() == Fluids.field_204547_b && drainLava.getAmount() == 1000) {
                            this.setFluid((Fluid)Fluids.field_204547_b);
                            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                            fluidHandler.drain(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.EXECUTE);
                            item.func_92058_a(fluidHandler.getContainer());
                            return true;
                        }
                    }
                    return false;
                }
                if (this.getFluid() == Fluids.field_204547_b) {
                    item.func_70015_d(100);
                    return true;
                }
                if (!SEED_PATTERN.matcher(stack.func_77977_a()).find()) break block13;
                for (RecipePetals recipe : BotaniaAPI.petalRecipes.values()) {
                    if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                    this.saveLastRecipe();
                    for (int i = 0; i < this.getSizeInventory(); ++i) {
                        this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    stack.func_190918_g(1);
                    ItemStack output = recipe.getOutput().func_77946_l();
                    ItemEntity outputItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                    outputItem.func_184211_a(ITEM_TAG_APOTHECARY_SPAWNED);
                    this.field_145850_b.func_217376_c((Entity)outputItem);
                    this.setFluid(Fluids.field_204541_a);
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                    this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, 0);
                    return true;
                }
                break block14;
            }
            if (hasFluidCapability || item.func_184216_O().contains(ITEM_TAG_APOTHECARY_SPAWNED)) break block14;
            if (!this.itemHandler.getStackInSlot(this.getSizeInventory() - 1).func_190926_b()) {
                return false;
            }
            for (int i = 0; i < this.getSizeInventory(); ++i) {
                if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
                this.itemHandler.setStackInSlot(i, stack.func_77979_a(1));
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
                return true;
            }
        }
        return false;
    }

    private ICustomApothecaryColor getFlowerComponent(ItemStack stack) {
        ICustomApothecaryColor c = null;
        if (stack.func_77973_b() instanceof ICustomApothecaryColor) {
            c = (ICustomApothecaryColor)stack.func_77973_b();
        } else if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ICustomApothecaryColor) {
            c = (ICustomApothecaryColor)((BlockItem)stack.func_77973_b()).func_179223_d();
        }
        return c;
    }

    public void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSizeInventory() && !(stack = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
            this.lastRecipe.add(stack.func_77946_l());
        }
        this.recipeKeepTicks = 400;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, 400);
    }

    public void trySetLastRecipe(PlayerEntity player) {
        TileAltar.tryToSetLastRecipe(player, (IItemHandlerModifiable)this.itemHandler, this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    public static void tryToSetLastRecipe(PlayerEntity player, IItemHandlerModifiable inv, List<ItemStack> lastRecipe) {
        if (lastRecipe == null || lastRecipe.isEmpty() || player.field_70170_p.field_72995_K) {
            return;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (ItemStack stack : lastRecipe) {
            if (stack.func_190926_b()) continue;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack pstack = player.field_71071_by.func_70301_a(i);
                if (!player.func_184812_l_() && (pstack.func_190926_b() || !pstack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)pstack))) continue;
                inv.setStackInSlot(index, player.func_184812_l_() ? stack.func_77946_l() : pstack.func_77979_a(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
            ServerPlayerEntity mp = (ServerPlayerEntity)player;
            mp.field_71069_bz.func_75142_b();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List items = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c.func_177963_a(0.0, 1.25, 0.0), this.field_174879_c.func_177963_a(1.0, 2.0, 1.0)));
            boolean didChange = false;
            for (ItemEntity item : items) {
                didChange = this.collideEntityItem(item) || didChange;
            }
            if (didChange) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        } else {
            ItemStack stackAt;
            for (int i = 0; i < this.getSizeInventory() && !(stackAt = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
                if (!(Math.random() >= 0.97)) continue;
                ICustomApothecaryColor comp = this.getFlowerComponent(stackAt);
                Color color = new Color(comp == null ? 0x888888 : comp.getParticleColor(stackAt));
                float red = (float)color.getRed() / 255.0f;
                float green = (float)color.getGreen() / 255.0f;
                float blue = (float)color.getBlue() / 255.0f;
                if (Math.random() >= 0.75) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.1f, 10.0f);
                }
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
            }
            if (this.getFluid() == Fluids.field_204547_b) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
                if (Math.random() > 0.9) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
                }
            }
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74778_a(TAG_FLUID, this.fluid.getRegistryName().toString());
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        super.readPacketNBT(cmp);
        ResourceLocation id = new ResourceLocation(cmp.func_74779_i(TAG_FLUID));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
    }

    public boolean func_145842_c(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.altarCraft, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.func_145842_c(id, param);
    }

    @Override
    public int getSizeInventory() {
        return 16;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(Fluid fluid) {
        Preconditions.checkArgument((fluid == Fluids.field_204546_a || fluid == Fluids.field_204547_b || fluid == Fluids.field_204541_a ? 1 : 0) != 0);
        this.fluid = fluid;
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc) {
        int xc = mc.field_195558_d.func_198107_o() / 2;
        int yc = mc.field_195558_d.func_198087_p() / 2;
        float angle = -90.0f;
        int radius = 24;
        int amt = 0;
        for (int i = 0; i < this.getSizeInventory() && !this.itemHandler.getStackInSlot(i).func_190926_b(); ++i) {
            ++amt;
        }
        if (amt > 0) {
            float anglePer = 360.0f / (float)amt;
            for (RecipePetals recipe : BotaniaAPI.petalRecipes.values()) {
                if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
                RenderHelper.drawTexturedModalRect(xc + radius + 9, yc - 8, 0.0f, 0, 8, 22, 15);
                ItemStack stack = recipe.getOutput();
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                mc.func_175599_af().func_175042_a(stack, xc + radius + 32, yc - 8);
                mc.func_175599_af().func_175042_a(new ItemStack((IItemProvider)Items.field_151014_N), xc + radius + 16, yc + 6);
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
                mc.field_71466_p.func_175063_a("+", (float)(xc + radius + 14), (float)(yc + 10), 0xFFFFFF);
            }
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            for (int i = 0; i < amt; ++i) {
                double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                GlStateManager.translated((double)xPos, (double)yPos, (double)0.0);
                mc.func_175599_af().func_175042_a(this.itemHandler.getStackInSlot(i), 0, 0);
                GlStateManager.translated((double)(-xPos), (double)(-yPos), (double)0.0);
                angle += anglePer;
            }
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        } else if (this.recipeKeepTicks > 0 && this.getFluid() == Fluids.field_204546_a) {
            String s = I18n.func_135052_a((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 10), 0xFFFFFF);
            s = I18n.func_135052_a((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 20), 0xFFFFFF);
        }
    }

    static {
        SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
    }
}

