/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.ColorHelper;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModBlocks;

public class SubTileSpectrolus
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:spectrolus")
    public static TileEntityType<SubTileSpectrolus> TYPE;
    public static final String TAG_NEXT_COLOR = "nextColor";
    private static final int WOOL_GEN = 1200;
    private static final int SHEEP_GEN = 5000;
    private static final int BABY_SHEEP_GEN = 1;
    private static final int RANGE = 1;
    private DyeColor nextColor = DyeColor.WHITE;

    public SubTileSpectrolus() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        List targets = this.func_145831_w().func_175647_a(SheepEntity.class, new AxisAlignedBB(this.getEffectivePos()), Entity::func_70089_S);
        AxisAlignedBB itemAABB = new AxisAlignedBB(this.getEffectivePos().func_177982_a(-1, -1, -1), this.getEffectivePos().func_177982_a(2, 2, 2));
        int slowdown = this.getSlowdownFactor();
        Predicate<Entity> selector = e -> e instanceof ItemEntity && e.func_70089_S() && ((ItemEntity)e).field_70292_b >= slowdown;
        targets.addAll(this.func_145831_w().func_175647_a(Entity.class, itemAABB, selector));
        for (Entity target : targets) {
            ItemStack stack;
            if (target instanceof SheepEntity) {
                SheepEntity sheep = (SheepEntity)target;
                if (!sheep.func_70892_o() && sheep.func_175509_cj() == this.nextColor) {
                    this.addManaAndCycle(sheep.func_70631_g_() ? 1 : 5000);
                    float pitch = sheep.func_70631_g_() ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.5f : (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f;
                    sheep.func_184185_a(SoundEvents.field_187759_eH, 0.9f, pitch);
                    sheep.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    ItemStack morbid = new ItemStack((IItemProvider)(sheep.func_70027_ad() ? Items.field_179557_bn : Items.field_179561_bm));
                    ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, morbid), target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05);
                    ItemStack wool = new ItemStack((IItemProvider)ModBlocks.getWool(sheep.func_175509_cj()));
                    ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, wool), target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05);
                }
                sheep.func_70606_j(0.0f);
                continue;
            }
            if (!(target instanceof ItemEntity) || (stack = ((ItemEntity)target).func_92059_d()).func_190926_b() || !ColorHelper.WOOL_MAP.containsValue((Object)Block.func_149634_a((Item)stack.func_77973_b()))) continue;
            Block expected = ModBlocks.getWool(this.nextColor);
            if (expected.func_199767_j() == stack.func_77973_b()) {
                this.addManaAndCycle(1200);
                ((ServerWorld)this.func_145831_w()).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), target.field_70165_t, target.field_70163_u, target.field_70161_v, 20, 0.1, 0.1, 0.1, 0.05);
            }
            target.func_70106_y();
        }
    }

    private void addManaAndCycle(int toAdd) {
        this.addMana(toAdd);
        this.nextColor = this.nextColor == DyeColor.BLACK ? DyeColor.WHITE : DyeColor.values()[this.nextColor.ordinal() + 1];
        this.sync();
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 16000;
    }

    @Override
    public int getColor() {
        return Color.HSBtoRGB((float)this.ticksExisted / 100.0f, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc) {
        super.renderHUD(mc);
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.getWool(this.nextColor));
        int color = this.getColor();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        if (!stack.func_190926_b()) {
            ITextComponent stackName = stack.func_200301_q();
            int width = 16 + mc.field_71466_p.func_78256_a(stackName.getString()) / 2;
            int x = mc.field_195558_d.func_198107_o() / 2 - width;
            int y = mc.field_195558_d.func_198087_p() / 2 + 30;
            mc.field_71466_p.func_175063_a(stackName.func_150254_d(), (float)(x + 20), (float)(y + 5), color);
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(stack, x, y);
            RenderHelper.func_74518_a();
        }
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_NEXT_COLOR, this.nextColor.ordinal());
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.nextColor = DyeColor.func_196056_a((int)cmp.func_74762_e(TAG_NEXT_COLOR));
    }
}

