/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileCocoon;
import vazkii.botania.common.item.ModItems;

public class BlockCocoon
extends BlockMod {
    private static final VoxelShape SHAPE = BlockCocoon.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    protected BlockCocoon(Block.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity e) {
        if (!world.field_72995_K && e instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)e;
            ItemStack stack = item.func_92059_d();
            this.addStack(world, pos, stack, false);
            if (stack.func_190926_b()) {
                item.func_70106_y();
            }
        }
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        return this.addStack(world, pos, stack, player.field_71075_bZ.field_75098_d);
    }

    private boolean addStack(World world, BlockPos pos, ItemStack stack, boolean creative) {
        TileCocoon cocoon = (TileCocoon)world.func_175625_s(pos);
        Item item = stack.func_77973_b();
        if (cocoon != null && (item == Items.field_151166_bC || item == Items.field_185161_cS || item == ModItems.lifeEssence)) {
            if (!world.field_72995_K) {
                if (item == Items.field_151166_bC && cocoon.emeraldsGiven < 20) {
                    if (!creative) {
                        stack.func_190918_g(1);
                    }
                    ++cocoon.emeraldsGiven;
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.1, 0.05, 0.1, 0.5);
                } else if (item == Items.field_185161_cS && cocoon.chorusFruitGiven < 20) {
                    if (!creative) {
                        stack.func_190918_g(1);
                    }
                    ++cocoon.chorusFruitGiven;
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 32, 0.0, 0.0, 0.0, 0.5);
                } else if (item == ModItems.lifeEssence && !cocoon.gaiaSpiritGiven) {
                    if (!creative) {
                        stack.func_190918_g(1);
                    }
                    cocoon.forceRare();
                    WispParticleData data = WispParticleData.wisp(0.6f, 0.0f, 1.0f, 0.0f);
                    ((ServerWorld)world).func_195598_a((IParticleData)data, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.7, (double)pos.func_177952_p() + 0.5, 8, 0.1, 0.1, 0.1, 0.04);
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileCocoon();
    }
}

