/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;

public class SkyblockSkyRenderer
implements IRenderHandler {
    private static final ResourceLocation textureSkybox = new ResourceLocation("botania:textures/misc/skybox.png");
    private static final ResourceLocation textureRainbow = new ResourceLocation("botania:textures/misc/rainbow.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation[] planetTextures = new ResourceLocation[]{new ResourceLocation("botania:textures/misc/planet0.png"), new ResourceLocation("botania:textures/misc/planet1.png"), new ResourceLocation("botania:textures/misc/planet2.png"), new ResourceLocation("botania:textures/misc/planet3.png"), new ResourceLocation("botania:textures/misc/planet4.png"), new ResourceLocation("botania:textures/misc/planet5.png")};

    public void render(int ticks, float partialTicks, ClientWorld world, Minecraft mc) {
        float celAng;
        int glSkyList = mc.field_71438_f.field_72771_w;
        VertexBuffer skyVBO = mc.field_71438_f.field_175012_t;
        GlStateManager.disableTexture();
        Vec3d vec3d = world.func_217382_a(mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        float insideVoid = 0.0f;
        if (mc.field_71439_g.field_70163_u <= -2.0) {
            insideVoid = (float)Math.min(1.0, -(mc.field_71439_g.field_70163_u + 2.0) / 30.0);
        }
        f = Math.max(0.0f, f - insideVoid);
        f1 = Math.max(0.0f, f1 - insideVoid);
        f2 = Math.max(0.0f, f2 - insideVoid);
        GlStateManager.color3f((float)f, (float)f1, (float)f2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableFog();
        GlStateManager.color3f((float)f, (float)f1, (float)f2);
        if (GLX.useVbo()) {
            skyVBO.func_177359_a();
            GlStateManager.enableClientState((int)32884);
            GlStateManager.vertexPointer((int)3, (int)5126, (int)12, (int)0);
            skyVBO.func_177358_a(7);
            skyVBO.func_177361_b();
            GlStateManager.disableClientState((int)32884);
        } else {
            GlStateManager.callList((int)glSkyList);
        }
        GlStateManager.disableFog();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.disableTexture();
            GlStateManager.shadeModel((int)7425);
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f3 = afloat[0];
            float f4 = afloat[1];
            float f5 = afloat[2];
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f3, f4, f5, afloat[3]).func_181675_d();
            int i = 16;
            for (int j = 0; j <= 16; ++j) {
                float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f7 = MathHelper.func_76126_a((float)f6);
                float f8 = MathHelper.func_76134_b((float)f6);
                bufferbuilder.func_181662_b((double)(f7 * 120.0f), (double)(f8 * 120.0f), (double)(-f8 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.enableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderExtra(world, partialTicks, insideVoid);
        GlStateManager.rotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f12 = 60.0f;
        mc.field_71446_o.func_110577_a(SUN_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f12), 100.0, (double)(-f12)).func_187315_a(0.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f12, 100.0, (double)(-f12)).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)f12, 100.0, (double)f12).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f12), 100.0, (double)f12).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        f12 = 60.0f;
        mc.field_71446_o.func_110577_a(MOON_PHASES_TEXTURES);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f9 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(-f12), -100.0, (double)f12).func_187315_a((double)f15, (double)f9).func_181675_d();
        bufferbuilder.func_181662_b((double)f12, -100.0, (double)f12).func_187315_a((double)f13, (double)f9).func_181675_d();
        bufferbuilder.func_181662_b((double)f12, -100.0, (double)(-f12)).func_187315_a((double)f13, (double)f14).func_181675_d();
        bufferbuilder.func_181662_b((double)(-f12), -100.0, (double)(-f12)).func_187315_a((double)f15, (double)f14).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableTexture();
        float effCelAng = celAng = world.func_72826_c(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float starAlpha = f11 * Math.max(0.1f, effCelAng * 2.0f);
        this.renderStars(mc, starAlpha, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableFog();
        GlStateManager.popMatrix();
        GlStateManager.enableTexture();
        GlStateManager.depthMask((boolean)true);
    }

    private void renderExtra(ClientWorld world, float partialTicks, float insideVoid) {
        float celAng;
        Tessellator tessellator = Tessellator.func_178181_a();
        float rain = 1.0f - world.func_72867_j(partialTicks);
        float effCelAng = celAng = world.func_72826_c(partialTicks);
        if ((double)celAng > 0.5) {
            effCelAng = 0.5f - (celAng - 0.5f);
        }
        float scale = 20.0f;
        float lowA = Math.max(0.0f, effCelAng - 0.3f) * rain;
        float a = Math.max(0.1f, lowA);
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(a * 4.0f * (1.0f - insideVoid)));
        GlStateManager.rotatef((float)90.0f, (float)0.5f, (float)0.5f, (float)0.0f);
        block11: for (int p = 0; p < planetTextures.length; ++p) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetTextures[p]);
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_181662_b((double)(-scale), 100.0, (double)(-scale)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)scale, 100.0, (double)(-scale)).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)scale, 100.0, (double)scale).func_187315_a(1.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(-scale), 100.0, (double)scale).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    GlStateManager.rotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    scale = 12.0f;
                    continue block11;
                }
                case 1: {
                    GlStateManager.rotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    scale = 15.0f;
                    continue block11;
                }
                case 2: {
                    GlStateManager.rotatef((float)80.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    scale = 25.0f;
                    continue block11;
                }
                case 3: {
                    GlStateManager.rotatef((float)100.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    scale = 10.0f;
                    continue block11;
                }
                case 4: {
                    GlStateManager.rotatef((float)-60.0f, (float)1.0f, (float)0.0f, (float)0.5f);
                    scale = 40.0f;
                }
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureSkybox);
        scale = 20.0f;
        a = lowA;
        GlStateManager.pushMatrix();
        GlStateManager.blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.rotatef((float)220.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        int angles = 90;
        float y = 2.0f;
        float y0 = 0.0f;
        float uPer = 0.0027777778f;
        float anglePer = 360.0f / (float)angles;
        double fuzzPer = Math.PI * 10 / (double)angles;
        float rotSpeed = 1.0f;
        float rotSpeedMod = 0.4f;
        block12: for (int p = 0; p < 3; ++p) {
            float baseAngle = rotSpeed * rotSpeedMod * ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks);
            GlStateManager.rotatef((float)(((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.25f * rotSpeed * rotSpeedMod), (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i < angles; ++i) {
                int j = i;
                if (i % 2 == 0) {
                    --j;
                }
                float ang = (float)j * anglePer + baseAngle;
                double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)scale;
                double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)scale;
                double yo = Math.sin(fuzzPer * (double)j) * 1.0;
                float ut = ang * uPer;
                if (i % 2 == 0) {
                    tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0 + (double)y, zp).func_187315_a((double)ut, 1.0).func_181675_d();
                    tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0, zp).func_187315_a((double)ut, 0.0).func_181675_d();
                    continue;
                }
                tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0, zp).func_187315_a((double)ut, 0.0).func_181675_d();
                tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0 + (double)y, zp).func_187315_a((double)ut, 1.0).func_181675_d();
            }
            tessellator.func_78381_a();
            switch (p) {
                case 0: {
                    GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.color4f((float)1.0f, (float)0.4f, (float)0.4f, (float)a);
                    fuzzPer = 43.982297150257104 / (double)angles;
                    rotSpeed = 0.2f;
                    continue block12;
                }
                case 1: {
                    GlStateManager.rotatef((float)50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.color4f((float)0.4f, (float)1.0f, (float)0.7f, (float)a);
                    fuzzPer = Math.PI * 6 / (double)angles;
                    rotSpeed = 2.0f;
                }
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(textureRainbow);
        scale = 10.0f;
        float effCelAng1 = celAng;
        if (effCelAng1 > 0.25f) {
            effCelAng1 = 1.0f - effCelAng1;
        }
        effCelAng1 = 0.25f - Math.min(0.25f, effCelAng1);
        long time = world.func_72820_D() + 1000L;
        int day = (int)(time / 24000L);
        Random rand = new Random(day * 255);
        float angle1 = rand.nextFloat() * 360.0f;
        float angle2 = rand.nextFloat() * 360.0f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(effCelAng1 * (1.0f - insideVoid)));
        GlStateManager.rotatef((float)angle1, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)angle2, (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < angles; ++i) {
            int j = i;
            if (i % 2 == 0) {
                --j;
            }
            float ang = (float)j * anglePer;
            double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)scale;
            double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)scale;
            double yo = 0.0;
            float ut = ang * uPer;
            if (i % 2 == 0) {
                tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0 + (double)y, zp).func_187315_a((double)ut, 1.0).func_181675_d();
                tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0, zp).func_187315_a((double)ut, 0.0).func_181675_d();
                continue;
            }
            tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0, zp).func_187315_a((double)ut, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(xp, yo + (double)y0 + (double)y, zp).func_187315_a((double)ut, 1.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - insideVoid));
        GlStateManager.blendFuncSeparate((int)770, (int)1, (int)1, (int)0);
    }

    private void renderStars(Minecraft mc, float alpha, float partialTicks) {
        int starGLCallList = mc.field_71438_f.field_72772_v;
        VertexBuffer starVBO = mc.field_71438_f.field_175013_s;
        float t = ((float)ClientTickHandler.ticksInGame + partialTicks + 2000.0f) * 0.005f;
        GlStateManager.pushMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(t * 3.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)t, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)alpha);
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(t * 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)alpha);
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(t * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)t, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)0.5f, (float)1.0f, (float)1.0f, (float)(0.25f * alpha));
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(t * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)0.75f, (float)0.75f, (float)(0.25f * alpha));
        this.drawVboOrList(starVBO, starGLCallList);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
    }

    private void drawVboOrList(VertexBuffer vbo, int displayList) {
        if (GLX.useVbo()) {
            vbo.func_177359_a();
            GlStateManager.enableClientState((int)32884);
            GlStateManager.vertexPointer((int)3, (int)5126, (int)12, (int)0);
            vbo.func_177358_a(7);
            vbo.func_177361_b();
            GlStateManager.disableClientState((int)32884);
        } else {
            GlStateManager.callList((int)displayList);
        }
    }
}

