/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.item.TinyPotatoRenderEvent;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.ModelTinyPotato;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

public class RenderTileTinyPotato
extends TileEntityRenderer<TileTinyPotato> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/tiny_potato.png");
    private static final ResourceLocation textureGrayscale = new ResourceLocation("botania:textures/model/tiny_potato_gray.png");
    private static final ResourceLocation textureHalloween = new ResourceLocation("botania:textures/model/tiny_potato_halloween.png");
    private static final ModelTinyPotato model = new ModelTinyPotato();

    private static boolean matches(String name, String match) {
        return name.equals(match) || name.startsWith(match + " ");
    }

    private static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    public void render(@Nonnull TileTinyPotato potato, double x, double y, double z, float partialTicks, int destroyStage) {
        boolean render;
        if (potato.func_195044_w().func_177230_c() != ModBlocks.tinyPotato) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)x, (double)y, (double)z);
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71446_o.func_110577_a(ClientProxy.dootDoot ? textureHalloween : texture);
        String name = potato.name.getString().toLowerCase().trim();
        boolean usedShader = false;
        if (RenderTileTinyPotato.matches(name, "gaia")) {
            ShaderHelper.useShader(ShaderHelper.doppleganger);
            name = RenderTileTinyPotato.removeFromFront(name, "gaia");
            usedShader = true;
        } else if (RenderTileTinyPotato.matches(name, "hot")) {
            ShaderHelper.useShader(ShaderHelper.halo);
            name = RenderTileTinyPotato.removeFromFront(name, "hot");
            usedShader = true;
        } else if (RenderTileTinyPotato.matches(name, "magic")) {
            ShaderHelper.useShader(ShaderHelper.enchanterRune);
            name = RenderTileTinyPotato.removeFromFront(name, "magic");
            usedShader = true;
        } else if (RenderTileTinyPotato.matches(name, "gold")) {
            ShaderHelper.useShader(ShaderHelper.gold);
            name = RenderTileTinyPotato.removeFromFront(name, "gold");
            usedShader = true;
        } else if (RenderTileTinyPotato.matches(name, "snoop")) {
            ShaderHelper.useShader(ShaderHelper.terraPlateRune);
            name = RenderTileTinyPotato.removeFromFront(name, "snoop");
            usedShader = true;
        }
        GlStateManager.translatef((float)0.5f, (float)1.5f, (float)0.5f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Direction potatoFacing = (Direction)potato.func_195044_w().func_177229_b(BotaniaStateProps.CARDINALS);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                break;
            }
            case NORTH: {
                rotY = 180.0f;
                break;
            }
            case EAST: {
                rotY = 270.0f;
                break;
            }
            case WEST: {
                rotY = 90.0f;
            }
        }
        GlStateManager.rotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)(-Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI))) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        GlStateManager.translatef((float)0.0f, (float)up, (float)0.0f);
        GlStateManager.rotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        switch (name) {
            case "pahimar": {
                GlStateManager.scalef((float)1.0f, (float)0.3f, (float)1.0f);
                GlStateManager.translatef((float)0.0f, (float)3.5f, (float)0.0f);
                break;
            }
            case "kyle hyde": {
                mc.field_71446_o.func_110577_a(textureGrayscale);
                break;
            }
            case "dinnerbone": 
            case "grumm": {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0f, (float)-2.625f, (float)0.0f);
                break;
            }
            case "aureylian": {
                GlStateManager.color3f((float)1.0f, (float)0.5f, (float)1.0f);
            }
        }
        boolean bl = render = !name.equals("mami") && !name.equals("soaryn") && (!name.equals("eloraam") || jump == 0.0f);
        if (render) {
            model.render();
        }
        if (name.equals("kingdaddydmac")) {
            GlStateManager.translatef((float)0.5f, (float)0.0f, (float)0.0f);
            model.render();
        }
        if (usedShader) {
            ShaderHelper.releaseShader();
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        float s = 0.2857143f;
        GlStateManager.scalef((float)s, (float)s, (float)s);
        for (int i = 0; i < potato.getSizeInventory(); ++i) {
            ItemStack stack = potato.getItemHandler().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            GlStateManager.pushMatrix();
            Direction side = ((Direction[])Direction.class.getEnumConstants())[i];
            if (side.func_176740_k() != Direction.Axis.Y) {
                float sideAngle = side.func_185119_l() - potatoFacing.func_185119_l();
                side = Direction.func_176733_a((double)sideAngle);
            }
            boolean block = stack.func_77973_b() instanceof BlockItem;
            boolean mySon = stack.func_77973_b() instanceof ItemBlockTinyPotato;
            switch (side) {
                case UP: {
                    if (mySon) {
                        GlStateManager.translatef((float)0.0f, (float)0.6f, (float)0.5f);
                    } else if (block) {
                        GlStateManager.translatef((float)0.0f, (float)0.3f, (float)0.5f);
                    }
                    GlStateManager.translatef((float)0.0f, (float)-0.5f, (float)-0.4f);
                    break;
                }
                case DOWN: {
                    GlStateManager.translatef((float)0.0f, (float)-2.3f, (float)-0.88f);
                    if (mySon) {
                        GlStateManager.translatef((float)0.0f, (float)0.65f, (float)0.6f);
                        break;
                    }
                    if (!block) break;
                    GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.6f);
                    break;
                }
                case NORTH: {
                    GlStateManager.translatef((float)0.0f, (float)-1.9f, (float)0.02f);
                    if (mySon) {
                        GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.6f);
                        break;
                    }
                    if (!block) break;
                    GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.6f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.translatef((float)0.0f, (float)-1.6f, (float)-0.89f);
                    if (mySon) {
                        GlStateManager.translatef((float)0.0f, (float)1.4f, (float)0.5f);
                        break;
                    }
                    if (!block) break;
                    GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.5f);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        GlStateManager.translatef((float)-0.4f, (float)0.65f, (float)0.0f);
                    } else if (block) {
                        GlStateManager.translatef((float)-0.4f, (float)0.8f, (float)0.0f);
                    } else {
                        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GlStateManager.translatef((float)-0.3f, (float)-1.9f, (float)0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        GlStateManager.translatef((float)1.0f, (float)0.65f, (float)1.0f);
                    } else if (block) {
                        GlStateManager.translatef((float)1.0f, (float)0.8f, (float)1.0f);
                    } else {
                        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GlStateManager.translatef((float)-0.3f, (float)-1.9f, (float)-0.92f);
                }
            }
            if (mySon) {
                GlStateManager.scalef((float)1.1f, (float)1.1f, (float)1.1f);
            } else if (block) {
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            if (block && side != Direction.NORTH) {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem(stack);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        if (!name.isEmpty()) {
            ContributorFancinessHandler.firstStart();
            float scale = 0.25f;
            GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            if (name.equals("phi") || name.equals("vazkii")) {
                GlStateManager.translatef((float)0.45f, (float)0.0f, (float)0.4f);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                this.renderIcon(MiscellaneousIcons.INSTANCE.phiFlowerIcon);
                if (name.equals("vazkii")) {
                    GlStateManager.rotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.scalef((float)1.25f, (float)1.25f, (float)1.25f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.translatef((float)-1.5f, (float)-1.3f, (float)-0.75f);
                    this.renderIcon(MiscellaneousIcons.INSTANCE.nerfBatIcon);
                }
            } else if (name.equals("haighyorkie")) {
                GlStateManager.scalef((float)1.25f, (float)1.25f, (float)1.25f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-1.2f, (float)-0.4f);
                this.renderIcon(MiscellaneousIcons.INSTANCE.goldfishIcon);
            } else if (name.equals("martysgames") || name.equals("marty")) {
                GlStateManager.scalef((float)0.7f, (float)0.7f, (float)0.7f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translatef((float)-0.3f, (float)-2.7f, (float)-1.2f);
                GlStateManager.rotatef((float)15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderItem(new ItemStack((IItemProvider)ModItems.infiniteFruit, 1).func_200302_a((ITextComponent)new StringTextComponent("das boot")));
            } else if (name.equals("jibril")) {
                GlStateManager.scalef((float)1.5f, (float)1.5f, (float)1.5f);
                GlStateManager.translatef((float)0.0f, (float)-0.8f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                ItemFlightTiara.renderHalo(null, partialTicks);
                GlStateManager.disableBlend();
                GlStateManager.disableLighting();
            } else if (name.equals("kingdaddydmac")) {
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)-3.0f, (float)0.65f);
                ItemStack ring = new ItemStack((IItemProvider)ModItems.manaRing);
                this.renderItem(ring);
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-4.0f);
                this.renderItem(ring);
                GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
                GlStateManager.translatef((float)1.25f, (float)-1.25f, (float)2.25f);
                mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                this.renderBlock(Blocks.field_150414_aQ);
            } else {
                ItemStack icon = ContributorFancinessHandler.getFlower(name);
                if (!icon.func_190926_b()) {
                    mc.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                    GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
                    ShaderHelper.useShader(ShaderHelper.gold);
                    this.renderItem(icon);
                    ShaderHelper.releaseShader();
                }
            }
        }
        GlStateManager.popMatrix();
        MinecraftForge.EVENT_BUS.post((Event)new TinyPotatoRenderEvent(potato, potato.name, x, y, z, partialTicks, destroyStage));
        GlStateManager.rotatef((float)(-rotZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)(-rotY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        RayTraceResult pos = mc.field_71476_x;
        if (!name.isEmpty() && pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK && potato.func_174877_v().equals((Object)((BlockRayTraceResult)pos).func_216350_a())) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-0.6f, (float)0.0f);
            GlStateManager.rotatef((float)(-mc.func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)mc.func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            float f = 1.6f;
            float f1 = 0.016666668f * f;
            GlStateManager.scalef((float)(-f1), (float)(-f1), (float)f1);
            GlStateManager.disableLighting();
            GlStateManager.translatef((float)0.0f, (float)(0.0f / f1), (float)0.0f);
            GlStateManager.depthMask((boolean)false);
            GlStateManager.enableBlend();
            GLX.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            GlStateManager.disableTexture();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int i = mc.field_71466_p.func_78256_a(potato.name.getString()) / 2;
            worldrenderer.func_181662_b((double)(-i - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(-i - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(i + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            worldrenderer.func_181662_b((double)(i + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            GlStateManager.depthMask((boolean)true);
            mc.field_71466_p.func_211126_b(potato.name.func_150254_d(), (float)(-i), 0.0f, 0xFFFFFF);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                GlStateManager.translatef((float)0.0f, (float)14.0f, (float)0.0f);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                GlStateManager.depthMask((boolean)false);
                GlStateManager.enableBlend();
                GLX.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager.disableTexture();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                i = mc.field_71466_p.func_78256_a(str) / 2;
                worldrenderer.func_181662_b((double)(-i - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                worldrenderer.func_181662_b((double)(-i - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                worldrenderer.func_181662_b((double)(i + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                worldrenderer.func_181662_b((double)(i + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.enableTexture();
                GlStateManager.depthMask((boolean)true);
                mc.field_71466_p.func_211126_b(str, (float)(-mc.field_71466_p.func_78256_a(str) / 2), 0.0f, 0xFFFFFF);
            }
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scalef((float)(1.0f / -f1), (float)(1.0f / -f1), (float)(1.0f / f1));
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }

    private void renderIcon(TextureAtlasSprite icon) {
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
    }

    private void renderItem(ItemStack stack) {
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.HEAD);
    }

    private void renderBlock(Block block) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_175602_ab().func_175016_a(block.func_176223_P(), 1.0f);
    }
}

