/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.ColorHelper;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.ModelSpreader;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class RenderTileSpreader
extends TileEntityRenderer<TileSpreader> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/spreader_mana.png");
    private static final ResourceLocation textureRs = new ResourceLocation("botania:textures/model/spreader_redstone.png");
    private static final ResourceLocation textureDw = new ResourceLocation("botania:textures/model/spreader_dreamwood.png");
    private static final ResourceLocation textureG = new ResourceLocation("botania:textures/model/spreader_gaia.png");
    private static final ResourceLocation textureHalloween = new ResourceLocation("botania:textures/model/spreader_mana_halloween.png");
    private static final ResourceLocation textureRsHalloween = new ResourceLocation("botania:textures/model/spreader_redstone_halloween.png");
    private static final ResourceLocation textureDwHalloween = new ResourceLocation("botania:textures/model/spreader_dreamwood_halloween.png");
    private static final ResourceLocation textureGHalloween = new ResourceLocation("botania:textures/model/spreader_gaia_halloween.png");
    private static final ModelSpreader model = new ModelSpreader();

    public void render(@Nonnull TileSpreader spreader, double d0, double d1, double d2, float ticks, int digProgress) {
        ResourceLocation r;
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)d0, (double)d1, (double)d2);
        GlStateManager.translatef((float)0.5f, (float)1.5f, (float)0.5f);
        GlStateManager.rotatef((float)(spreader.rotationX + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.rotatef((float)spreader.rotationY, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.0f);
        ResourceLocation resourceLocation = spreader.isRedstone() ? textureRs : (spreader.isDreamwood() ? textureDw : (r = spreader.isULTRA_SPREADER() ? textureG : texture));
        if (ClientProxy.dootDoot) {
            r = spreader.isRedstone() ? textureRsHalloween : (spreader.isDreamwood() ? textureDwHalloween : (spreader.isULTRA_SPREADER() ? textureGHalloween : textureHalloween));
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(r);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        double time = (float)ClientTickHandler.ticksInGame + ticks;
        if (spreader.isULTRA_SPREADER()) {
            Color color = Color.getHSBColor((float)((time * 5.0 + (double)new Random(spreader.func_174877_v().hashCode()).nextInt(10000)) % 360.0) / 360.0f, 0.4f, 0.9f);
            GlStateManager.color3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        }
        model.render();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.pushMatrix();
        double worldTicks = spreader.func_145831_w() == null ? 0.0 : time;
        GlStateManager.rotatef((float)((float)worldTicks % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)((float)Math.sin(worldTicks / 20.0) * 0.05f), (float)0.0f);
        model.renderCube();
        GlStateManager.popMatrix();
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        ItemStack stack = spreader.getItemHandler().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            stack.func_77973_b();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)-1.0f, (float)-0.4675f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scalef((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.popMatrix();
        }
        if (spreader.paddingColor != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            BlockState carpet = ((Block)ColorHelper.CARPET_MAP.get((Object)spreader.paddingColor)).func_176223_P();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)0.5f);
            float f = 0.0625f;
            GlStateManager.translatef((float)0.0f, (float)(-f - 0.001f), (float)0.0f);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(carpet, 1.0f);
            GlStateManager.translatef((float)0.0f, (float)(f + 0.001f), (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.001f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(carpet, 1.0f);
            GlStateManager.translatef((float)0.0f, (float)0.001f, (float)0.0f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)(15.0f * f + 0.001f), (float)-0.001f);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(carpet, 1.0f);
            GlStateManager.translatef((float)0.0f, (float)-0.001f, (float)0.001f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)(15.0f * f + 0.001f), (float)f, (float)0.001f);
            GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(carpet, 1.0f);
            GlStateManager.translatef((float)-0.001f, (float)0.0f, (float)-0.001f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.001f, (float)(-1.0f + f + 0.001f), (float)(-f + 0.001f));
            GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175602_ab().func_175016_a(carpet, 1.0f);
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.popMatrix();
    }
}

