/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.model.ModelPylonGaia;
import vazkii.botania.client.model.ModelPylonMana;
import vazkii.botania.client.model.ModelPylonNatura;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.tile.TilePylon;

public class RenderTilePylon
extends TileEntityRenderer<TilePylon> {
    private static final ResourceLocation MANA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_mana.png");
    private static final ResourceLocation NATURA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_natura.png");
    private static final ResourceLocation GAIA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_gaia.png");
    private final ModelPylonMana manaModel = new ModelPylonMana();
    private final ModelPylonNatura naturaModel = new ModelPylonNatura();
    private final ModelPylonGaia gaiaModel = new ModelPylonGaia();
    private static BlockPylon.Variant forceVariant = BlockPylon.Variant.MANA;

    public void render(@Nonnull TilePylon pylon, double d0, double d1, double d2, float pticks, int digProgress) {
        if (!pylon.func_145831_w().func_175667_e(pylon.func_174877_v()) || !(pylon.func_195044_w().func_177230_c() instanceof BlockPylon)) {
            return;
        }
        this.renderPylon(pylon, d0, d1, d2, pticks);
    }

    private void renderPylon(@Nullable TilePylon pylon, double d0, double d1, double d2, float pticks) {
        Model model;
        BlockPylon.Variant type = pylon == null ? forceVariant : ((BlockPylon)pylon.func_195044_w().func_177230_c()).variant;
        switch (type) {
            default: {
                model = this.manaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(MANA_TEXTURE);
                break;
            }
            case NATURA: {
                model = this.naturaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(NATURA_TEXTURE);
                break;
            }
            case GAIA: {
                model = this.gaiaModel;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(GAIA_TEXTURE);
            }
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0 : (double)new Random(pylon.func_174877_v().hashCode()).nextInt(360);
        GlStateManager.translated((double)d0, (double)(d1 + (pylon == null ? 1.35 : 1.5)), (double)d2);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.5f, (float)0.0f, (float)-0.5f);
        if (pylon != null) {
            GlStateManager.rotatef((float)((float)worldTime * 1.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        model.renderRing();
        if (pylon != null) {
            GlStateManager.translated((double)0.0, (double)(Math.sin(worldTime / 20.0) / 20.0 - 0.025), (double)0.0);
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        if (pylon != null) {
            GlStateManager.translated((double)0.0, (double)(Math.sin(worldTime / 20.0) / 17.5), (double)0.0);
        }
        GlStateManager.translatef((float)0.5f, (float)0.0f, (float)-0.5f);
        if (pylon != null) {
            GlStateManager.rotatef((float)((float)(-worldTime)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.disableCull();
        GlStateManager.disableAlphaTest();
        if (pylon != null) {
            ShaderHelper.useShader(ShaderHelper.pylonGlow);
        }
        model.renderCrystal();
        if (pylon != null) {
            ShaderHelper.releaseShader();
        }
        GlStateManager.enableAlphaTest();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
        GlStateManager.enableRescaleNormal();
        GlStateManager.popMatrix();
    }

    public static class TEISR
    extends ItemStackTileEntityRenderer {
        public void func_179022_a(ItemStack stack) {
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPylon) {
                forceVariant = ((BlockPylon)Block.func_149634_a((Item)stack.func_77973_b())).variant;
                TileEntityRenderer r = TileEntityRendererDispatcher.field_147556_a.func_147546_a(TilePylon.class);
                ((RenderTilePylon)r).renderPylon(null, 0.0, 0.0, 0.0, 0.0f);
                GlStateManager.enableBlend();
            }
        }
    }
}

