/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.client.model.GunModel;
import vazkii.botania.client.model.LexiconModel;
import vazkii.botania.client.model.PlatformModel;
import vazkii.botania.client.render.tile.RenderTileCorporeaCrystalCube;
import vazkii.botania.client.render.tile.RenderTilePump;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class MiscellaneousIcons {
    public static final MiscellaneousIcons INSTANCE = new MiscellaneousIcons();
    public TextureAtlasSprite alfPortalTex;
    public TextureAtlasSprite lightRelayWorldIcon;
    public TextureAtlasSprite lightRelayWorldIconRed;
    public TextureAtlasSprite lightRelayWorldIconGreen;
    public TextureAtlasSprite lightRelayWorldIconPurple;
    public TextureAtlasSprite alchemyCatalystOverlay;
    public TextureAtlasSprite conjurationCatalystOverlay;
    public TextureAtlasSprite enchanterOverlay;
    public TextureAtlasSprite manaVoidOverlay;
    public TextureAtlasSprite manaWater;
    public TextureAtlasSprite terraPlateOverlay;
    public TextureAtlasSprite corporeaWorldIcon;
    public TextureAtlasSprite corporeaWorldIconMaster;
    public TextureAtlasSprite corporeaIconStar;
    public TextureAtlasSprite sparkWorldIcon;
    public TextureAtlasSprite manaDetectorIcon;
    public TextureAtlasSprite runeAltarTriggerIcon;
    public TextureAtlasSprite terrasteelHelmWillIcon;
    public final TextureAtlasSprite[] sparkUpgradeIcons = new TextureAtlasSprite[4];
    public final TextureAtlasSprite[] kingKeyWeaponIcons = new TextureAtlasSprite[12];
    public final TextureAtlasSprite[] tiaraWingIcons = new TextureAtlasSprite[9];
    public final TextureAtlasSprite[] thirdEyeLayers = new TextureAtlasSprite[3];
    public TextureAtlasSprite tailIcon = null;
    public TextureAtlasSprite phiFlowerIcon = null;
    public TextureAtlasSprite goldfishIcon = null;
    public TextureAtlasSprite nerfBatIcon = null;
    public TextureAtlasSprite bloodPendantChain;
    public TextureAtlasSprite bloodPendantGem;
    public TextureAtlasSprite snowflakePendantGem;
    public TextureAtlasSprite itemFinderGem;
    public TextureAtlasSprite pyroclastGem;
    public TextureAtlasSprite crimsonGem;
    public TextureAtlasSprite cirrusGem;
    public TextureAtlasSprite nimbusGem;

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        if (!ModelHandler.registeredModels) {
            Botania.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        ModelDynBucket bowl = new ModelDynBucket(ResourceLocationHelper.prefix("items/waterbowl_base"), ResourceLocationHelper.prefix("items/waterbowl_fluid"), ResourceLocationHelper.prefix("items/waterbowl_cover"), (Fluid)Fluids.field_204546_a, false, true);
        IModelState transform = (IModelState)ForgeBlockStateV1.Transforms.get((String)"forge:default-item").get();
        IBakedModel bakedBowl = bowl.bake((ModelBakery)evt.getModelLoader(), ModelLoader.defaultTextureGetter(), (ISprite)new BasicState(transform, false), DefaultVertexFormats.field_176599_b);
        evt.getModelRegistry().put(new ModelResourceLocation(ModItems.waterBowl.getRegistryName(), "inventory"), bakedBowl);
        for (Map.Entry e : evt.getModelRegistry().entrySet()) {
            if (!(e.getValue() instanceof FloatingFlowerModel.Baked)) continue;
            ResourceLocation stripVariant = new ResourceLocation(((ResourceLocation)e.getKey()).func_110624_b(), ((ResourceLocation)e.getKey()).func_110623_a());
            ModelResourceLocation itemPath = new ModelResourceLocation(stripVariant, "inventory");
            evt.getModelRegistry().put(itemPath, e.getValue());
        }
        ModelResourceLocation abstruseName = new ModelResourceLocation("botania:abstruse_platform", "");
        IBakedModel abstruse = (IBakedModel)evt.getModelRegistry().get(abstruseName);
        ModelResourceLocation spectralName = new ModelResourceLocation("botania:spectral_platform", "");
        IBakedModel spectral = (IBakedModel)evt.getModelRegistry().get(spectralName);
        ModelResourceLocation infrangibleName = new ModelResourceLocation("botania:infrangible_platform", "");
        IBakedModel infrangible = (IBakedModel)evt.getModelRegistry().get(infrangibleName);
        evt.getModelRegistry().put(abstruseName, new PlatformModel(abstruse));
        evt.getModelRegistry().put(spectralName, new PlatformModel(spectral));
        evt.getModelRegistry().put(infrangibleName, new PlatformModel(infrangible));
        IBakedModel original = (IBakedModel)evt.getModelRegistry().get(new ModelResourceLocation("botania:lexicon", "inventory"));
        evt.getModelRegistry().put(new ModelResourceLocation("botania:lexicon", "inventory"), new LexiconModel(original));
        for (int i = 0; i < original.func_188617_f().field_209582_c.size(); ++i) {
            original.func_188617_f().field_209582_c.set(i, new LexiconModel((IBakedModel)original.func_188617_f().field_209582_c.get(i)));
        }
        ModelResourceLocation key = new ModelResourceLocation("botania:mana_gun", "inventory");
        IBakedModel originalModel = (IBakedModel)evt.getModelRegistry().get(key);
        ModelResourceLocation clipKey = new ModelResourceLocation("botania:mana_gun_clip", "inventory");
        IBakedModel originalModelClip = (IBakedModel)evt.getModelRegistry().get(clipKey);
        evt.getModelRegistry().put(key, new GunModel((ModelBakery)evt.getModelLoader(), originalModel, originalModelClip));
        RenderTileCorporeaCrystalCube.cubeModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        RenderTilePump.headModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/mana_pump_head"));
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre evt) {
        int i;
        if (evt.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        evt.addSprite(ResourceLocationHelper.prefix("blocks/alfheim_portal_swirl"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/alfheim_portal_swirl"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_detector"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_fork"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_toggle"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/catalyst_alchemy_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/catalyst_conjuration_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/enchanter_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/mana_void_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/mana_water"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/terra_plate_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea_master"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea_star"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark"));
        for (i = 0; i < 4; ++i) {
            evt.addSprite(ResourceLocationHelper.prefix("items/spark_upgrade_rune_" + i));
        }
        evt.addSprite(ResourceLocationHelper.prefix("items/special_tail"));
        evt.addSprite(ResourceLocationHelper.prefix("items/special_phiflower"));
        evt.addSprite(ResourceLocationHelper.prefix("items/special_goldfish"));
        evt.addSprite(ResourceLocationHelper.prefix("items/special_nerfbat"));
        for (i = 0; i < 12; ++i) {
            evt.addSprite(ResourceLocationHelper.prefix("items/gate_weapon_" + i));
        }
        for (i = 0; i < 3; ++i) {
            evt.addSprite(ResourceLocationHelper.prefix("items/third_eye_" + i));
        }
        evt.addSprite(ResourceLocationHelper.prefix("items/triggers/mana_detector"));
        evt.addSprite(ResourceLocationHelper.prefix("items/triggers/rune_altar_can_craft"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            evt.addSprite(ResourceLocationHelper.prefix("items/headpiece_tiara_wing_" + (i + 1)));
        }
        evt.addSprite(ResourceLocationHelper.prefix("items/will_flame"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_blood_chain"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_blood_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_ice_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/headpiece_item_finder_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_lava_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_lava_super_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_cloud_gem"));
        evt.addSprite(ResourceLocationHelper.prefix("items/pendant_cloud_super_gem"));
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post evt) {
        int i;
        if (evt.getMap() != Minecraft.func_71410_x().func_147117_R()) {
            return;
        }
        this.alfPortalTex = this.get(evt.getMap(), "blocks/alfheim_portal_swirl");
        this.lightRelayWorldIcon = this.get(evt.getMap(), "blocks/luminizer");
        this.lightRelayWorldIconRed = this.get(evt.getMap(), "blocks/luminizer_detector");
        this.lightRelayWorldIconGreen = this.get(evt.getMap(), "blocks/luminizer_fork");
        this.lightRelayWorldIconPurple = this.get(evt.getMap(), "blocks/luminizer_toggle");
        this.alchemyCatalystOverlay = this.get(evt.getMap(), "blocks/catalyst_alchemy_overlay");
        this.conjurationCatalystOverlay = this.get(evt.getMap(), "blocks/catalyst_conjuration_overlay");
        this.enchanterOverlay = this.get(evt.getMap(), "blocks/enchanter_overlay");
        this.manaVoidOverlay = this.get(evt.getMap(), "blocks/mana_void_overlay");
        this.manaWater = this.get(evt.getMap(), "blocks/mana_water");
        this.terraPlateOverlay = this.get(evt.getMap(), "blocks/terra_plate_overlay");
        this.corporeaWorldIcon = this.get(evt.getMap(), "items/spark_corporea");
        this.corporeaWorldIconMaster = this.get(evt.getMap(), "items/spark_corporea_master");
        this.corporeaIconStar = this.get(evt.getMap(), "items/spark_corporea_star");
        this.sparkWorldIcon = this.get(evt.getMap(), "items/spark");
        for (i = 0; i < 4; ++i) {
            this.sparkUpgradeIcons[i] = this.get(evt.getMap(), "items/spark_upgrade_rune_" + i);
        }
        this.tailIcon = this.get(evt.getMap(), "items/special_tail");
        this.phiFlowerIcon = this.get(evt.getMap(), "items/special_phiflower");
        this.goldfishIcon = this.get(evt.getMap(), "items/special_goldfish");
        this.nerfBatIcon = this.get(evt.getMap(), "items/special_nerfbat");
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponIcons[i] = this.get(evt.getMap(), "items/gate_weapon_" + i);
        }
        for (i = 0; i < 3; ++i) {
            this.thirdEyeLayers[i] = this.get(evt.getMap(), "items/third_eye_" + i);
        }
        this.manaDetectorIcon = this.get(evt.getMap(), "items/triggers/mana_detector");
        this.runeAltarTriggerIcon = this.get(evt.getMap(), "items/triggers/rune_altar_can_craft");
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            this.tiaraWingIcons[i] = this.get(evt.getMap(), "items/headpiece_tiara_wing_" + (i + 1));
        }
        this.terrasteelHelmWillIcon = this.get(evt.getMap(), "items/will_flame");
        this.bloodPendantChain = this.get(evt.getMap(), "items/pendant_blood_chain");
        this.bloodPendantGem = this.get(evt.getMap(), "items/pendant_blood_gem");
        this.snowflakePendantGem = this.get(evt.getMap(), "items/pendant_ice_gem");
        this.itemFinderGem = this.get(evt.getMap(), "items/headpiece_item_finder_gem");
        this.pyroclastGem = this.get(evt.getMap(), "items/pendant_lava_gem");
        this.crimsonGem = this.get(evt.getMap(), "items/pendant_lava_super_gem");
        this.cirrusGem = this.get(evt.getMap(), "items/pendant_cloud_gem");
        this.nimbusGem = this.get(evt.getMap(), "items/pendant_cloud_super_gem");
    }

    private TextureAtlasSprite get(AtlasTexture map, String name) {
        return map.func_195424_a(new ResourceLocation("botania", name));
    }

    private MiscellaneousIcons() {
    }
}

