/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.botania.common.core.helper.ItemNBTHelper;

@Mod.EventBusSubscriber(modid="botania")
public class ItemKeepIvy
extends Item {
    public static final String TAG_KEEP = "Botania_keepIvy";
    private static final String TAG_PLAYER_KEPT_DROPS = "Botania_playerKeptDrops";
    private static final String TAG_DROP_COUNT = "dropCount";
    private static final String TAG_DROP_PREFIX = "dropPrefix";

    public ItemKeepIvy(Item.Properties props) {
        super(props);
    }

    @SubscribeEvent
    public static void onPlayerDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        ArrayList<ItemEntity> keeps = new ArrayList<ItemEntity>();
        for (ItemEntity item : event.getDrops()) {
            ItemStack stack = item.func_92059_d();
            if (stack.func_190926_b() || !stack.func_77942_o() || !ItemNBTHelper.getBoolean(stack, TAG_KEEP, false)) continue;
            keeps.add(item);
        }
        if (keeps.size() > 0) {
            event.getDrops().removeAll(keeps);
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_74768_a(TAG_DROP_COUNT, keeps.size());
            int i = 0;
            for (ItemEntity keep : keeps) {
                ItemStack stack = keep.func_92059_d();
                CompoundNBT cmp1 = stack.func_77955_b(new CompoundNBT());
                cmp.func_218657_a(TAG_DROP_PREFIX + i, (INBT)cmp1);
                ++i;
            }
            CompoundNBT data = event.getEntityLiving().getPersistentData();
            if (!data.func_74764_b("PlayerPersisted")) {
                data.func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
            }
            CompoundNBT persist = data.func_74775_l("PlayerPersisted");
            persist.func_218657_a(TAG_PLAYER_KEPT_DROPS, (INBT)cmp);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CompoundNBT data = event.getPlayer().getPersistentData();
        if (data.func_74764_b("PlayerPersisted")) {
            CompoundNBT cmp = data.func_74775_l("PlayerPersisted");
            CompoundNBT cmp1 = cmp.func_74775_l(TAG_PLAYER_KEPT_DROPS);
            int count = cmp1.func_74762_e(TAG_DROP_COUNT);
            for (int i = 0; i < count; ++i) {
                CompoundNBT cmp2 = cmp1.func_74775_l(TAG_DROP_PREFIX + i);
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)cmp2);
                if (stack.func_190926_b()) continue;
                ItemStack copy = stack.func_77946_l();
                ItemNBTHelper.setBoolean(copy, TAG_KEEP, false);
                event.getPlayer().field_71071_by.func_70441_a(copy);
            }
            cmp.func_82580_o(TAG_PLAYER_KEPT_DROPS);
        }
    }
}

