/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;

public class ItemBlackHoleTalisman
extends Item
implements IBlockProvider {
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_COUNT = "blockCount";

    public ItemBlackHoleTalisman(Item.Properties props) {
        super(props);
        this.func_185043_a(new ResourceLocation("botania", TAG_ACTIVE), (stack, worldIn, entityIn) -> ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false) ? 1.0f : 0.0f);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemBlackHoleTalisman.getBlock(stack) != null && player.func_225608_bj_()) {
            ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
            player.func_184185_a(SoundEvents.field_187604_bf, 0.3f, 0.1f);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack toUse;
        ActionResultType result;
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        PlayerEntity player = ctx.func_195999_j();
        BlockState state = world.func_180495_p(pos);
        ItemStack stack = ctx.func_195996_i();
        if (!state.isAir((IBlockReader)world, pos) && this.setBlock(stack, state.func_177230_c())) {
            return ActionResultType.SUCCESS;
        }
        Block bBlock = ItemBlackHoleTalisman.getBlock(stack);
        if (bBlock == null) {
            return ActionResultType.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent()) {
            if (!world.field_72995_K) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).ifPresent(inv -> {
                    ItemStack toAdd = new ItemStack((IItemProvider)bBlock);
                    int maxSize = toAdd.func_77976_d();
                    toAdd.func_190920_e(ItemBlackHoleTalisman.remove(stack, maxSize));
                    ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)toAdd, (boolean)false);
                    if (!remainder.func_190926_b()) {
                        this.add(stack, remainder.func_190916_E());
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        if ((player == null || player.field_71075_bZ.field_75098_d || ItemBlackHoleTalisman.getBlockCount(stack) > 0) && (result = PlayerHelper.substituteUse(ctx, toUse = new ItemStack((IItemProvider)bBlock))) == ActionResultType.SUCCESS) {
            ItemBlackHoleTalisman.remove(stack, 1);
            ItemsRemainingRenderHandler.set(toUse, ItemBlackHoleTalisman.getBlockCount(stack));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean selected) {
        Block block = ItemBlackHoleTalisman.getBlock(itemstack);
        if (!entity.field_70170_p.field_72995_K && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null && entity instanceof PlayerEntity) {
            int i;
            PlayerEntity player = (PlayerEntity)entity;
            int highest = -1;
            int[] counts = new int[player.field_71071_by.func_70302_i_() - player.field_71071_by.field_70460_b.size()];
            for (i = 0; i < counts.length; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || block.func_199767_j() != stack.func_77973_b()) continue;
                counts[i] = stack.func_190916_E();
                highest = highest == -1 ? i : (counts[i] > counts[highest] && highest > 8 ? i : highest);
            }
            if (highest != -1) {
                for (i = 0; i < counts.length; ++i) {
                    int count = counts[i];
                    if (count == 0) continue;
                    this.add(itemstack, count);
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        Block block = ItemBlackHoleTalisman.getBlock(stack);
        ItemStack bstack = new ItemStack((IItemProvider)block);
        ITextComponent cand = super.func_200295_i(stack);
        if (!bstack.func_190926_b()) {
            cand.func_150258_a(" (");
            cand.func_150257_a(bstack.func_200301_q().func_211708_a(TextFormatting.GREEN));
            cand.func_150258_a(")");
        }
        return cand;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        int count = ItemBlackHoleTalisman.getBlockCount(itemStack);
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        int extract = Math.min(64, count);
        ItemStack copy = itemStack.func_77946_l();
        ItemBlackHoleTalisman.remove(copy, extract);
        ItemNBTHelper.setBoolean(copy, TAG_ACTIVE, false);
        return copy;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getContainerItem(stack).func_190926_b();
    }

    private boolean setBlock(ItemStack stack, Block block) {
        if (block.func_199767_j() != Items.field_190931_a && (ItemBlackHoleTalisman.getBlock(stack) == null || ItemBlackHoleTalisman.getBlockCount(stack) == 0)) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, block.getRegistryName().toString());
            return true;
        }
        return false;
    }

    private void add(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, current + count);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        Block block = ItemBlackHoleTalisman.getBlock(stack);
        if (block != null) {
            int count = ItemBlackHoleTalisman.getBlockCount(stack);
            stacks.add(new StringTextComponent(Integer.toString(count) + " ").func_150257_a(new ItemStack((IItemProvider)block).func_200301_q()).func_211708_a(TextFormatting.GRAY));
        }
        if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.active", new Object[0]));
        } else {
            stacks.add((ITextComponent)new TranslationTextComponent("botaniamisc.inactive", new Object[0]));
        }
    }

    private static void setCount(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = ItemBlackHoleTalisman.getBlockCount(stack);
        ItemBlackHoleTalisman.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    private static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)ItemBlackHoleTalisman.getBlockName(stack));
        if (id != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(id);
        }
        return null;
    }

    public static int getBlockCount(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    @Override
    public boolean provideBlock(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block, boolean doit) {
        int count;
        Block stored = ItemBlackHoleTalisman.getBlock(stack);
        if (stored == block && (count = ItemBlackHoleTalisman.getBlockCount(stack)) > 0) {
            if (doit) {
                ItemBlackHoleTalisman.setCount(stack, count - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getBlockCount(PlayerEntity player, ItemStack requestor, ItemStack stack, Block block) {
        Block stored = ItemBlackHoleTalisman.getBlock(stack);
        if (stored == block) {
            return ItemBlackHoleTalisman.getBlockCount(stack);
        }
        return 0;
    }
}

