/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;

public class CosmeticAttachRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<CosmeticAttachRecipe> SERIALIZER = new SpecialRecipeSerializer(CosmeticAttachRecipe::new);

    public CosmeticAttachRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundCosmetic = false;
        boolean foundAttachable = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICosmeticBauble && !foundCosmetic) {
                foundCosmetic = true;
                continue;
            }
            if (foundAttachable) continue;
            if (stack.func_77973_b() instanceof ICosmeticAttachable && !(stack.func_77973_b() instanceof ICosmeticBauble) && ((ICosmeticAttachable)stack.func_77973_b()).getCosmeticItem(stack).func_190926_b()) {
                foundAttachable = true;
                continue;
            }
            return false;
        }
        return foundCosmetic && foundAttachable;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack cosmeticItem = ItemStack.field_190927_a;
        ItemStack attachableItem = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICosmeticBauble && cosmeticItem.func_190926_b()) {
                cosmeticItem = stack;
                continue;
            }
            attachableItem = stack;
        }
        if (!(attachableItem.func_77973_b() instanceof ICosmeticAttachable)) {
            return ItemStack.field_190927_a;
        }
        ICosmeticAttachable attachable = (ICosmeticAttachable)attachableItem.func_77973_b();
        if (!attachable.getCosmeticItem(attachableItem).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = attachableItem.func_77946_l();
        attachable.setCosmeticItem(copy, cosmeticItem);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

