/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.CorporeaIndexRequestEvent;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.core.helper.MathHelper;

public class TileCorporeaIndex
extends TileCorporeaBase
implements ICorporeaRequestor,
ITickableTileEntity {
    @ObjectHolder(value="botania:corporea_index")
    public static TileEntityType<TileCorporeaIndex> TYPE;
    public static final double RADIUS = 2.5;
    private static InputHandler input;
    private static final Set<TileCorporeaIndex> serverIndexes;
    private static final Set<TileCorporeaIndex> clientIndexes;
    private static final Map<Pattern, IRegexStacker> patterns;
    public int ticks = 0;
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    public TileCorporeaIndex() {
        super(TYPE);
    }

    public void func_73660_a() {
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        this.hasCloseby = false;
        for (PlayerEntity player : players) {
            if (!TileCorporeaIndex.isInRangeOfIndex(player, this)) continue;
            this.hasCloseby = true;
            break;
        }
        float step = 0.2f;
        ++this.ticks;
        if (this.hasCloseby) {
            ++this.ticksWithCloseby;
            if (this.closeby < 1.0f) {
                this.closeby += step;
            }
        } else if (this.closeby > 0.0f) {
            this.closeby -= step;
        }
        if (!this.func_145837_r()) {
            TileCorporeaIndex.addIndex(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        TileCorporeaIndex.removeIndex(this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        TileCorporeaIndex.removeIndex(this);
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        List<ItemStack> stacks = CorporeaHelper.requestItem(request, count, spark, true);
        spark.onItemsRequested(stacks);
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
            this.field_145850_b.func_217376_c((Entity)item);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInRangeOfIndex(PlayerEntity player, TileCorporeaIndex index) {
        if (player.field_71093_bK != index.field_145850_b.func_201675_m().func_186058_p()) return false;
        if (!((double)MathHelper.pointDistancePlane((double)index.func_174877_v().func_177958_n() + 0.5, (double)index.func_174877_v().func_177952_p() + 0.5, player.func_226277_ct_(), player.func_226281_cx_()) < 2.5)) return false;
        double d = (double)index.func_174877_v().func_177956_o() + 0.5 - player.func_226278_cu_();
        double d2 = player.field_70170_p.field_72995_K ? 0.0 : 1.6;
        if (!(Math.abs(d + d2) < 5.0)) return false;
        return true;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static InputHandler getInputHandler() {
        if (input == null) {
            input = new InputHandler();
        }
        return input;
    }

    private static void addIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.field_145850_b.field_72995_K ? clientIndexes : serverIndexes;
        set.add(index);
    }

    private static void removeIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.field_145850_b.field_72995_K ? clientIndexes : serverIndexes;
        set.remove(index);
    }

    public void performPlayerRequest(ServerPlayerEntity player, ICorporeaRequestMatcher request, int count) {
        CorporeaIndexRequestEvent indexReqEvent = new CorporeaIndexRequestEvent(player, request, count, this.getSpark());
        if (!MinecraftForge.EVENT_BUS.post((Event)indexReqEvent)) {
            this.doCorporeaRequest(request, count, this.getSpark());
            player.func_145747_a(new TranslationTextComponent("botaniamisc.requestMsg", new Object[]{count, request.getRequestName(), CorporeaHelper.lastRequestMatches, CorporeaHelper.lastRequestExtractions}).func_211708_a(TextFormatting.LIGHT_PURPLE));
            CorporeaRequestTrigger.INSTANCE.trigger(player, player.func_71121_q(), this.func_174877_v(), CorporeaHelper.lastRequestExtractions);
        }
    }

    static {
        serverIndexes = Collections.newSetFromMap(new WeakHashMap());
        clientIndexes = Collections.newSetFromMap(new WeakHashMap());
        patterns = new LinkedHashMap<Pattern, IRegexStacker>();
        TileCorporeaIndex.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1) + TileCorporeaIndex.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return Integer.MAX_VALUE;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?nice (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? nices?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }

    public static final class InputHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onChatMessage(ServerChatEvent event) {
            if (event.getPlayer().func_175149_v()) {
                return;
            }
            List<TileCorporeaIndex> nearbyIndexes = InputHandler.getNearbyIndexes((PlayerEntity)event.getPlayer());
            if (!nearbyIndexes.isEmpty()) {
                String msg = event.getMessage().toLowerCase().trim();
                for (TileCorporeaIndex index : nearbyIndexes) {
                    ItemStack stack;
                    ICorporeaSpark spark = index.getSpark();
                    if (spark == null) continue;
                    String name = "";
                    int count = 0;
                    for (Pattern pattern : patterns.keySet()) {
                        Matcher matcher = pattern.matcher(msg);
                        if (!matcher.matches()) continue;
                        IRegexStacker stacker = (IRegexStacker)patterns.get(pattern);
                        count = stacker.getCount(matcher);
                        name = stacker.getName(matcher).toLowerCase().trim();
                    }
                    if (name.equals("this") && !(stack = event.getPlayer().func_184614_ca()).func_190926_b()) {
                        name = stack.func_200301_q().getString().toLowerCase().trim();
                    }
                    index.performPlayerRequest(event.getPlayer(), CorporeaHelper.createMatcher(name), count);
                }
                event.setCanceled(true);
            }
        }

        public static List<TileCorporeaIndex> getNearbyIndexes(PlayerEntity player) {
            return (player.field_70170_p.field_72995_K ? clientIndexes : serverIndexes).stream().filter(i -> TileCorporeaIndex.isInRangeOfIndex(player, i)).collect(Collectors.toList());
        }
    }
}

