/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCell;

public class SubTileDandelifeon
extends TileEntityGeneratingFlower {
    @ObjectHolder(value="botania:dandelifeon")
    public static TileEntityType<SubTileDandelifeon> TYPE;
    private static final int RANGE = 12;
    private static final int SPEED = 10;
    private static final int MAX_MANA_GENERATIONS = 100;
    private static final int MANA_PER_GEN = 60;
    private static final int[][] ADJACENT_BLOCKS;

    public SubTileDandelifeon() {
        super(TYPE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.func_145831_w().field_72995_K && this.redstoneSignal > 0 && this.ticksExisted % 10 == 0) {
            this.runSimulation();
        }
    }

    private void runSimulation() {
        int[][] table = this.getCellTable();
        ArrayList<int[]> changes = new ArrayList<int[]>();
        boolean wipe = false;
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[0].length; ++j) {
                int gen = table[i][j];
                int adj = this.getAdjCells(table, i, j);
                int newVal = gen;
                if (adj < 2 || adj > 3) {
                    newVal = -1;
                } else if (adj == 3 && gen == -1) {
                    newVal = this.getSpawnCellGeneration(table, i, j);
                } else if (gen > -1) {
                    newVal = gen + 1;
                }
                int xdist = Math.abs(i - 12);
                int zdist = Math.abs(j - 12);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && newVal > -1) {
                    gen = newVal;
                    int n = newVal = gen == 1 ? -1 : -2;
                }
                if (newVal == gen) continue;
                changes.add(new int[]{i, j, newVal, gen});
                if (newVal != -2) continue;
                wipe = true;
            }
        }
        BlockPos pos = this.getEffectivePos();
        for (int[] change : changes) {
            BlockPos pos_ = pos.func_177982_a(-12 + change[0], 0, -12 + change[1]);
            int val = change[2];
            if (val != -2 && wipe) {
                val = -1;
            }
            int old = change[3];
            this.setBlockForGeneration(pos_, val, old);
        }
    }

    private int[][] getCellTable() {
        int diam = 25;
        int[][] table = new int[diam][diam];
        BlockPos pos = this.getEffectivePos();
        for (int i = 0; i < diam; ++i) {
            for (int j = 0; j < diam; ++j) {
                BlockPos pos_ = pos.func_177982_a(-12 + i, 0, -12 + j);
                table[i][j] = this.getCellGeneration(pos_);
            }
        }
        return table;
    }

    private int getCellGeneration(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileCell) {
            return ((TileCell)tile).isSameFlower(this) ? ((TileCell)tile).getGeneration() : 0;
        }
        return -1;
    }

    private int getAdjCells(int[][] table, int x, int z) {
        int count = 0;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) < 0) continue;
            ++count;
        }
        return count;
    }

    private int getSpawnCellGeneration(int[][] table, int x, int z) {
        int max = -1;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) <= max) continue;
            max = gen;
        }
        return max == -1 ? -1 : max + 1;
    }

    boolean isOffBounds(int[][] table, int x, int z) {
        return x < 0 || z < 0 || x >= table.length || z >= table[0].length;
    }

    void setBlockForGeneration(BlockPos pos, int gen, int prevGen) {
        World world = this.func_145831_w();
        BlockState stateAt = world.func_180495_p(pos);
        Block blockAt = stateAt.func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (gen == -2) {
            int val = Math.min(100, prevGen) * 60;
            this.addMana(val);
        } else if (blockAt == ModBlocks.cellBlock) {
            if (gen < 0) {
                world.func_217377_a(pos, false);
            } else {
                ((TileCell)tile).setGeneration(this, gen);
            }
        } else if (gen >= 0 && stateAt.isAir((IBlockReader)this.func_145831_w(), pos)) {
            world.func_175656_a(pos, ModBlocks.cellBlock.func_176223_P());
            tile = world.func_175625_s(pos);
            ((TileCell)tile).setGeneration(this, gen);
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 12);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }

    static {
        ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};
    }
}

