/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IRegistryDelegate;
import vazkii.botania.api.ColorHelper;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.model.ModelSpreader;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class RenderTileSpreader
extends TileEntityRenderer<TileSpreader> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/spreader_mana.png");
    private static final ResourceLocation textureRs = new ResourceLocation("botania:textures/model/spreader_redstone.png");
    private static final ResourceLocation textureDw = new ResourceLocation("botania:textures/model/spreader_dreamwood.png");
    private static final ResourceLocation textureG = new ResourceLocation("botania:textures/model/spreader_gaia.png");
    private static final ResourceLocation textureHalloween = new ResourceLocation("botania:textures/model/spreader_mana_halloween.png");
    private static final ResourceLocation textureRsHalloween = new ResourceLocation("botania:textures/model/spreader_redstone_halloween.png");
    private static final ResourceLocation textureDwHalloween = new ResourceLocation("botania:textures/model/spreader_dreamwood_halloween.png");
    private static final ResourceLocation textureGHalloween = new ResourceLocation("botania:textures/model/spreader_gaia_halloween.png");
    private static final ModelSpreader model = new ModelSpreader();

    public RenderTileSpreader(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nonnull TileSpreader spreader, float ticks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ResourceLocation texture;
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 1.5, 0.5);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(spreader.rotationX + 90.0f));
        ms.func_227861_a_(0.0, -1.0, 0.0);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(spreader.rotationY));
        ms.func_227861_a_(0.0, 1.0, 0.0);
        ResourceLocation resourceLocation = spreader.isRedstone() ? textureRs : (spreader.isDreamwood() ? textureDw : (texture = spreader.isULTRA_SPREADER() ? textureG : RenderTileSpreader.texture));
        if (ClientProxy.dootDoot) {
            texture = spreader.isRedstone() ? textureRsHalloween : (spreader.isDreamwood() ? textureDwHalloween : (spreader.isULTRA_SPREADER() ? textureGHalloween : textureHalloween));
        }
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        double time = (float)ClientTickHandler.ticksInGame + ticks;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (spreader.isULTRA_SPREADER()) {
            int color = MathHelper.func_181758_c((float)((float)((time * 5.0 + (double)new Random(spreader.func_174877_v().hashCode()).nextInt(10000)) % 360.0) / 360.0f), (float)0.4f, (float)0.9f);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        IVertexBuilder buffer = buffers.getBuffer(model.func_228282_a_(texture));
        model.func_225598_a_(ms, buffer, light, overlay, r, g, b, 1.0f);
        ms.func_227860_a_();
        double worldTicks = spreader.func_145831_w() == null ? 0.0 : time;
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)worldTicks % 360.0f));
        ms.func_227861_a_(0.0, (double)((float)Math.sin(worldTicks / 20.0) * 0.05f), 0.0);
        model.renderCube(ms, buffer, light, overlay);
        ms.func_227865_b_();
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        ItemStack stack = spreader.getItemHandler().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, -1.0, (double)-0.4675f);
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            ms.func_227862_a_(1.0f, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, light, overlay, ms, buffers);
            ms.func_227865_b_();
        }
        if (spreader.paddingColor != null) {
            BlockState carpet = ((Block)((IRegistryDelegate)ColorHelper.CARPET_MAP.get((Object)spreader.paddingColor)).get()).func_176223_P();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(carpet);
            buffer = buffers.getBuffer(RenderTypeLookup.func_228394_b_((BlockState)carpet));
            float f = 0.0625f;
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227861_a_(-0.5, (double)(0.5f - f), 0.5);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            ms.func_227861_a_(0.5, 0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            ms.func_227861_a_(-1.5, 0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227861_a_(-0.5, -0.5, (double)(-0.5f - f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            ms.func_227861_a_(-0.5, (double)(-1.5f - f), (double)(-0.5f + f));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, carpet, model, 1.0f, 1.0f, 1.0f, light, overlay);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }
}

