/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.MathHelper;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.mana.TilePool;

public class RenderTilePool
extends TileEntityRenderer<TilePool> {
    public static int cartMana = -1;

    public RenderTilePool(TileEntityRendererDispatcher manager) {
        super(manager);
    }

    public void render(@Nullable TilePool pool, float f, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        TextureAtlasSprite overlayIcon;
        Block below;
        int cap;
        boolean fab;
        if (!(pool == null || pool.func_145831_w().func_175667_e(pool.func_174877_v()) && pool.func_195044_w().func_177230_c() instanceof BlockPool)) {
            return;
        }
        ms.func_227860_a_();
        boolean bl = fab = pool != null && ((BlockPool)pool.func_195044_w().func_177230_c()).variant == BlockPool.Variant.FABULOUS;
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            int color = MathHelper.func_181758_c((float)((time += (float)new Random(pool.func_174877_v().func_177958_n() ^ pool.func_174877_v().func_177956_o() ^ pool.func_174877_v().func_177952_p()).nextInt(100000)) * 0.005f), (float)0.6f, (float)1.0f);
            int red = (color & 0xFF0000) >> 16;
            int green = (color & 0xFF00) >> 8;
            int blue = color & 0xFF;
            BlockState state = pool.func_195044_w();
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            IVertexBuilder buffer = buffers.getBuffer(RenderTypeLookup.func_228394_b_((BlockState)state));
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, state, model, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, light, overlay);
        }
        ms.func_227861_a_(0.5, 1.5, 0.5);
        int mana = pool == null ? cartMana : pool.getCurrentMana();
        int n = cap = pool == null ? -1 : pool.manaCap;
        if (cap == -1) {
            cap = 1000000;
        }
        float waterLevel = (float)mana / (float)cap * 0.4f;
        float s = 0.0625f;
        float v = 0.125f;
        float w = -v * 3.5f;
        if (pool != null && (below = pool.func_145831_w().func_180495_p(pool.func_174877_v().func_177977_b()).func_177230_c()) instanceof IPoolOverlayProvider && (overlayIcon = ((IPoolOverlayProvider)below).getIcon(pool.func_145831_w(), pool.func_174877_v())) != null) {
            ms.func_227860_a_();
            float alpha = (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2);
            ms.func_227861_a_(-0.5, -1.4300000667572021, -0.5);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227862_a_(s, s, s);
            IVertexBuilder buffer = buffers.getBuffer(RenderHelper.ICON_OVERLAY);
            IconHelper.renderIcon(ms, buffer, 0, 0, overlayIcon, 16, 16, alpha);
            ms.func_227865_b_();
        }
        if (waterLevel > 0.0f) {
            s = 0.0546875f;
            ms.func_227860_a_();
            ms.func_227861_a_((double)w, (double)(-1.0f - (0.43f - waterLevel)), (double)w);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            ms.func_227862_a_(s, s, s);
            IVertexBuilder buffer = buffers.getBuffer(RenderHelper.MANA_POOL_WATER);
            IconHelper.renderIcon(ms, buffer, 0, 0, MiscellaneousIcons.INSTANCE.manaWater, 16, 16, 1.0f);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
        cartMana = -1;
    }
}

