/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;

public class PlatformModel
extends BakedModelWrapper<IBakedModel> {
    public PlatformModel(IBakedModel original) {
        super(original);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (state == null) {
            return ImmutableList.of();
        }
        if (!(state.func_177230_c() instanceof BlockPlatform)) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_200117_a(state, side, rand);
        }
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == null) {
            layer = RenderType.func_228639_c_();
        }
        BlockState heldState = (BlockState)data.getData(BotaniaStateProps.HELD_STATE);
        BlockPos heldPos = (BlockPos)data.getData(BotaniaStateProps.HELD_POS);
        if (heldPos == null) {
            return ImmutableList.of();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (heldState == null && layer == RenderType.func_228639_c_()) {
            return this.originalModel.getQuads(state, side, rand, data);
        }
        if (heldState != null) {
            if (heldState.func_177230_c() == ModBlocks.manaGlass) {
                return ImmutableList.of();
            }
            if (RenderTypeLookup.canRenderInLayer((BlockState)heldState, (RenderType)layer)) {
                IBakedModel model = mc.func_175602_ab().func_175023_a().func_178125_b(heldState);
                return model.getQuads(heldState, side, rand, (IModelData)EmptyModelData.INSTANCE);
            }
        }
        return ImmutableList.of();
    }
}

