/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.elventrade;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.block.ModBlocks;

public class ElvenTradeRecipeCategory
implements IRecipeCategory<RecipeElvenTrade> {
    public static final ResourceLocation UID = new ResourceLocation("botania", "elven_trade");
    private final String localizedName = I18n.func_135052_a((String)"botania.nei.elvenTrade", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/elven_trade_overlay.png"), 0, 15, 140, 90);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.alfPortal));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends RecipeElvenTrade> getRecipeClass() {
        return RecipeElvenTrade.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(RecipeElvenTrade recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.getInputs()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, (List)ImmutableList.copyOf(recipe.getOutputs()));
    }

    public void draw(RecipeElvenTrade recipe, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = MiscellaneousIcons.INSTANCE.alfPortalTex;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int startX = 22;
        int startY = 25;
        int stopX = 70;
        int stopY = 73;
        wr.func_225582_a_((double)startX, (double)startY, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
        wr.func_225582_a_((double)startX, (double)stopY, 0.0).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        wr.func_225582_a_((double)stopX, (double)stopY, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        wr.func_225582_a_((double)stopX, (double)startY, 0.0).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        tess.func_78381_a();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeElvenTrade recipe, @Nonnull IIngredients ingredients) {
        int index = 0;
        int posX = 42;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, posX, 0);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            recipeLayout.getItemStacks().init(index + i, false, 93 + i % 2 * 20, 41 + i / 2 * 20);
            recipeLayout.getItemStacks().set(index + i, stacks);
        }
    }
}

