/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.botania.client.core.handler.RenderLexicon;
import vazkii.botania.client.model.FloatingFlowerModel;
import vazkii.botania.client.model.GunModel;
import vazkii.botania.client.model.LexiconModel;
import vazkii.botania.client.model.PlatformModel;
import vazkii.botania.client.render.tile.RenderTileCorporeaCrystalCube;
import vazkii.botania.client.render.tile.RenderTilePump;
import vazkii.botania.common.lib.LibObfuscation;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class MiscellaneousIcons {
    private static final MethodHandle MATERIALS = LibObfuscation.getGetter(ModelBakery.class, "field_177602_b");
    public static final MiscellaneousIcons INSTANCE = new MiscellaneousIcons();
    public TextureAtlasSprite alfPortalTex;
    public TextureAtlasSprite lightRelayWorldIcon;
    public TextureAtlasSprite lightRelayWorldIconRed;
    public TextureAtlasSprite lightRelayWorldIconGreen;
    public TextureAtlasSprite lightRelayWorldIconPurple;
    public TextureAtlasSprite alchemyCatalystOverlay;
    public TextureAtlasSprite conjurationCatalystOverlay;
    public TextureAtlasSprite enchanterOverlay;
    public TextureAtlasSprite manaVoidOverlay;
    public TextureAtlasSprite manaWater;
    public TextureAtlasSprite terraPlateOverlay;
    public TextureAtlasSprite corporeaWorldIcon;
    public TextureAtlasSprite corporeaWorldIconMaster;
    public TextureAtlasSprite corporeaIconStar;
    public TextureAtlasSprite sparkWorldIcon;
    public TextureAtlasSprite manaDetectorIcon;
    public TextureAtlasSprite runeAltarTriggerIcon;
    public final TextureAtlasSprite[] sparkUpgradeIcons = new TextureAtlasSprite[4];
    public final IBakedModel[] tiaraWingIcons = new IBakedModel[9];
    public final IBakedModel[] thirdEyeLayers = new IBakedModel[3];
    public TextureAtlasSprite tailIcon = null;
    public IBakedModel goldfishModel;
    public IBakedModel phiFlowerModel;
    public IBakedModel nerfBatModel;
    public IBakedModel bloodPendantChain;
    public IBakedModel bloodPendantGem;
    public IBakedModel snowflakePendantGem;
    public IBakedModel itemFinderGem;
    public IBakedModel pyroclastGem;
    public IBakedModel crimsonGem;
    public IBakedModel cirrusGem;
    public IBakedModel nimbusGem;
    public IBakedModel terrasteelHelmWillModel;
    public final IBakedModel[] kingKeyWeaponModels = new IBakedModel[12];

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent evt) throws Throwable {
        int i;
        Set materials = MATERIALS.invokeExact();
        materials.add(RenderLexicon.TEXTURE);
        materials.add(RenderLexicon.ELVEN_TEXTURE);
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/goldfish"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/phiflower"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/nerfbat"));
        for (i = 0; i < 12; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        int i;
        for (Map.Entry e : evt.getModelRegistry().entrySet()) {
            if (!(e.getValue() instanceof FloatingFlowerModel.Baked)) continue;
            ResourceLocation stripVariant = new ResourceLocation(((ResourceLocation)e.getKey()).func_110624_b(), ((ResourceLocation)e.getKey()).func_110623_a());
            ModelResourceLocation itemPath = new ModelResourceLocation(stripVariant, "inventory");
            evt.getModelRegistry().put(itemPath, e.getValue());
        }
        ModelResourceLocation abstruseName = new ModelResourceLocation("botania:abstruse_platform", "");
        IBakedModel abstruse = (IBakedModel)evt.getModelRegistry().get(abstruseName);
        ModelResourceLocation spectralName = new ModelResourceLocation("botania:spectral_platform", "");
        IBakedModel spectral = (IBakedModel)evt.getModelRegistry().get(spectralName);
        ModelResourceLocation infrangibleName = new ModelResourceLocation("botania:infrangible_platform", "");
        IBakedModel infrangible = (IBakedModel)evt.getModelRegistry().get(infrangibleName);
        evt.getModelRegistry().put(abstruseName, new PlatformModel(abstruse));
        evt.getModelRegistry().put(spectralName, new PlatformModel(spectral));
        evt.getModelRegistry().put(infrangibleName, new PlatformModel(infrangible));
        IBakedModel original = (IBakedModel)evt.getModelRegistry().get(new ModelResourceLocation("botania:lexicon", "inventory"));
        evt.getModelRegistry().put(new ModelResourceLocation("botania:lexicon", "inventory"), new LexiconModel(original));
        for (int i2 = 0; i2 < original.func_188617_f().field_209582_c.size(); ++i2) {
            original.func_188617_f().field_209582_c.set(i2, new LexiconModel((IBakedModel)original.func_188617_f().field_209582_c.get(i2)));
        }
        ModelResourceLocation key = new ModelResourceLocation("botania:mana_gun", "inventory");
        IBakedModel originalModel = (IBakedModel)evt.getModelRegistry().get(key);
        ModelResourceLocation clipKey = new ModelResourceLocation("botania:mana_gun_clip", "inventory");
        IBakedModel originalModelClip = (IBakedModel)evt.getModelRegistry().get(clipKey);
        evt.getModelRegistry().put(key, new GunModel((ModelBakery)evt.getModelLoader(), originalModel, originalModelClip));
        RenderTileCorporeaCrystalCube.cubeModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/corporea_crystal_cube_glass"));
        RenderTilePump.headModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("block/pump_head"));
        this.goldfishModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/goldfish"));
        this.phiFlowerModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/phiflower"));
        this.nerfBatModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/nerfbat"));
        for (i = 0; i < 12; ++i) {
            this.kingKeyWeaponModels[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/gate_weapon_" + i));
        }
        this.terrasteelHelmWillModel = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/will_flame"));
        for (i = 0; i < this.thirdEyeLayers.length; ++i) {
            this.thirdEyeLayers[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/third_eye_" + i));
        }
        this.pyroclastGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/lava_pendant_gem"));
        this.crimsonGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/super_lava_pendant_gem"));
        this.itemFinderGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/itemfinder_gem"));
        this.cirrusGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/cloud_pendant_gem"));
        this.nimbusGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/super_cloud_pendant_gem"));
        this.snowflakePendantGem = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/ice_pendant_gem"));
        for (i = 0; i < this.tiaraWingIcons.length; ++i) {
            this.tiaraWingIcons[i] = (IBakedModel)evt.getModelRegistry().get(ResourceLocationHelper.prefix("icon/tiara_wing_" + (i + 1)));
        }
    }

    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre evt) {
        if (!evt.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        evt.addSprite(ResourceLocationHelper.prefix("blocks/alfheim_portal_swirl"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/alfheim_portal_swirl"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_detector"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_fork"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/luminizer_toggle"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/catalyst_alchemy_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/catalyst_conjuration_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/enchanter_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/mana_void_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/mana_water"));
        evt.addSprite(ResourceLocationHelper.prefix("blocks/terra_plate_overlay"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea_master"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark_corporea_star"));
        evt.addSprite(ResourceLocationHelper.prefix("items/spark"));
        for (int i = 0; i < 4; ++i) {
            evt.addSprite(ResourceLocationHelper.prefix("items/spark_upgrade_rune_" + i));
        }
        evt.addSprite(ResourceLocationHelper.prefix("items/special_tail"));
    }

    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post evt) {
        if (!evt.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        this.alfPortalTex = this.get(evt.getMap(), "blocks/alfheim_portal_swirl");
        this.lightRelayWorldIcon = this.get(evt.getMap(), "blocks/luminizer");
        this.lightRelayWorldIconRed = this.get(evt.getMap(), "blocks/luminizer_detector");
        this.lightRelayWorldIconGreen = this.get(evt.getMap(), "blocks/luminizer_fork");
        this.lightRelayWorldIconPurple = this.get(evt.getMap(), "blocks/luminizer_toggle");
        this.alchemyCatalystOverlay = this.get(evt.getMap(), "blocks/catalyst_alchemy_overlay");
        this.conjurationCatalystOverlay = this.get(evt.getMap(), "blocks/catalyst_conjuration_overlay");
        this.enchanterOverlay = this.get(evt.getMap(), "blocks/enchanter_overlay");
        this.manaVoidOverlay = this.get(evt.getMap(), "blocks/mana_void_overlay");
        this.manaWater = this.get(evt.getMap(), "blocks/mana_water");
        this.terraPlateOverlay = this.get(evt.getMap(), "blocks/terra_plate_overlay");
        this.corporeaWorldIcon = this.get(evt.getMap(), "items/spark_corporea");
        this.corporeaWorldIconMaster = this.get(evt.getMap(), "items/spark_corporea_master");
        this.corporeaIconStar = this.get(evt.getMap(), "items/spark_corporea_star");
        this.sparkWorldIcon = this.get(evt.getMap(), "items/spark");
        for (int i = 0; i < 4; ++i) {
            this.sparkUpgradeIcons[i] = this.get(evt.getMap(), "items/spark_upgrade_rune_" + i);
        }
        this.tailIcon = this.get(evt.getMap(), "items/special_tail");
    }

    private TextureAtlasSprite get(AtlasTexture map, String name) {
        return map.func_195424_a(ResourceLocationHelper.prefix(name));
    }

    private MiscellaneousIcons() {
    }
}

