/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IItemProvider;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ModTags;

public final class ContributorFancinessHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final Map<String, ItemStack> flowerMap = new HashMap<String, ItemStack>();
    private static boolean startedLoading = false;
    private static final ImmutableMap<String, String> LEGACY_FLOWER_NAMES = ImmutableMap.builder().put((Object)"puredaisy", (Object)LibBlockNames.SUBTILE_PUREDAISY.func_110623_a()).put((Object)"fallenkanade", (Object)LibBlockNames.SUBTILE_FALLEN_KANADE.func_110623_a()).put((Object)"heiseidream", (Object)LibBlockNames.SUBTILE_HEISEI_DREAM.func_110623_a()).put((Object)"arcanerose", (Object)LibBlockNames.SUBTILE_ARCANE_ROSE.func_110623_a()).put((Object)"jadedamaranthus", (Object)LibBlockNames.SUBTILE_JADED_AMARANTHUS.func_110623_a()).put((Object)"orechidignem", (Object)LibBlockNames.SUBTILE_ORECHID_IGNEM.func_110623_a()).build();

    public ContributorFancinessHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public void render(MatrixStack ms, IRenderTypeBuffer buffers, int light, @Nonnull AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (player.func_82150_aj()) {
            return;
        }
        String name = player.func_145748_c_().getString();
        AccessoryRenderHelper.translateToHeadLevel(ms, (LivingEntity)player, partialTicks);
        if (name.equals("haighyorkie")) {
            ContributorFancinessHandler.renderGoldfish(ms, buffers, light, (PlayerEntity)player);
        }
        ContributorFancinessHandler.firstStart();
        name = name.toLowerCase();
        if (player.func_175148_a(PlayerModelPart.CAPE) && flowerMap.containsKey(name)) {
            ContributorFancinessHandler.renderFlower(ms, buffers, (PlayerEntity)player, flowerMap.get(name));
        }
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        flowerMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                flowerMap.put(key, new ItemStack((IItemProvider)ModBlocks.getFlower(DyeColor.func_196056_a((int)i))));
            }
            catch (NumberFormatException e) {
                String rawName = value.toLowerCase(Locale.ROOT);
                String flowerName = (String)LEGACY_FLOWER_NAMES.getOrDefault((Object)rawName, (Object)rawName);
                Item item = ModTags.Items.SPECIAL_FLOWERS.func_199885_a().stream().filter(flower -> flower.getRegistryName().func_110623_a().equals(flowerName)).findFirst().orElse(Items.field_221620_aV);
                flowerMap.put(key, new ItemStack((IItemProvider)item));
            }
        }
    }

    private static void renderGoldfish(MatrixStack ms, IRenderTypeBuffer buffers, int light, PlayerEntity player) {
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, (double)player.func_70047_e(), 0.0);
        AccessoryRenderHelper.rotateIfSneaking(ms, (LivingEntity)player);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        ms.func_227862_a_(0.4f, 0.4f, 0.4f);
        ms.func_227861_a_(-0.5, (double)1.6f, 0.0);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffers.getBuffer(Atlases.func_228784_i_()), null, MiscellaneousIcons.INSTANCE.goldfishModel, 1.0f, 1.0f, 1.0f, light, OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
    }

    private static void renderFlower(MatrixStack ms, IRenderTypeBuffer buffers, PlayerEntity player, ItemStack flower) {
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ms.func_227861_a_(0.0, -0.85, 0.0);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        ms.func_227862_a_(0.5f, 0.5f, 0.5f);
        RenderHelper.renderItemModelGold((LivingEntity)player, flower, ItemCameraTransforms.TransformType.NONE, ms, buffers, player.field_70170_p, 0xF000F0, OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Botania Contributor Fanciness Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(Botania.LOGGER));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorFancinessHandler.load(props);
                }
            }
            catch (IOException e) {
                Botania.LOGGER.info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

