/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.corporea;

import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public final class CorporeaRequestDefaultMatchers {
    private CorporeaRequestDefaultMatchers() {
    }

    public static class CorporeaItemStackMatcher
    implements ICorporeaRequestMatcher {
        private static final String TAG_REQUEST_STACK = "requestStack";
        private static final String TAG_REQUEST_CHECK_NBT = "requestCheckNBT";
        private final ItemStack match;
        private final boolean checkNBT;

        public CorporeaItemStackMatcher(ItemStack match, boolean checkNBT) {
            this.match = match;
            this.checkNBT = checkNBT;
        }

        @Override
        public boolean isStackValid(ItemStack stack) {
            return !stack.func_190926_b() && !this.match.func_190926_b() && stack.func_77969_a(this.match) && (!this.checkNBT || ItemNBTHelper.matchTag((INBT)this.match.func_77978_p(), (INBT)stack.func_77978_p()));
        }

        public static ICorporeaRequestMatcher createFromNBT(CompoundNBT tag) {
            return new CorporeaItemStackMatcher(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(TAG_REQUEST_STACK)), tag.func_74767_n(TAG_REQUEST_CHECK_NBT));
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            CompoundNBT cmp = this.match.func_77955_b(new CompoundNBT());
            tag.func_218657_a(TAG_REQUEST_STACK, (INBT)cmp);
            tag.func_74757_a(TAG_REQUEST_CHECK_NBT, this.checkNBT);
        }

        @Override
        public ITextComponent getRequestName() {
            return this.match.func_151000_E();
        }
    }

    public static class CorporeaStringMatcher
    implements ICorporeaRequestMatcher {
        private static final Pattern patternControlCode = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
        public static final String[] WILDCARD_STRINGS = new String[]{"...", "~", "+", "?", "*"};
        private static final String TAG_REQUEST_CONTENTS = "requestContents";
        private static final String TAG_REQUEST_CONTAINS = "requestContains";
        private final String expression;
        private final boolean contains;

        public CorporeaStringMatcher(String expression) {
            boolean contains = false;
            for (String wc : WILDCARD_STRINGS) {
                if (expression.endsWith(wc)) {
                    contains = true;
                    expression = expression.substring(0, expression.length() - wc.length());
                } else if (expression.startsWith(wc)) {
                    contains = true;
                    expression = expression.substring(wc.length());
                }
                if (contains) break;
            }
            this.expression = expression;
            this.contains = contains;
        }

        private CorporeaStringMatcher(String expression, boolean contains) {
            this.expression = expression;
            this.contains = contains;
        }

        @Override
        public boolean isStackValid(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            String name = CorporeaStringMatcher.stripControlCodes(stack.func_200301_q().getString().toLowerCase().trim());
            return this.equalOrContain(name) || this.equalOrContain(name + "s") || this.equalOrContain(name + "es") || name.endsWith("y") && this.equalOrContain(name.substring(0, name.length() - 1) + "ies");
        }

        public static ICorporeaRequestMatcher createFromNBT(CompoundNBT tag) {
            String expression = tag.func_74779_i(TAG_REQUEST_CONTENTS);
            boolean contains = tag.func_74767_n(TAG_REQUEST_CONTAINS);
            return new CorporeaStringMatcher(expression, contains);
        }

        @Override
        public void writeToNBT(CompoundNBT tag) {
            tag.func_74778_a(TAG_REQUEST_CONTENTS, this.expression);
            tag.func_74757_a(TAG_REQUEST_CONTAINS, this.contains);
        }

        @Override
        public ITextComponent getRequestName() {
            return new StringTextComponent(WordUtils.capitalizeFully((String)this.expression));
        }

        private boolean equalOrContain(String str) {
            return this.contains ? str.contains(this.expression) : str.equals(this.expression);
        }

        private static String stripControlCodes(String str) {
            return patternControlCode.matcher(str).replaceAll("");
        }
    }
}

