/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.item.AccessoryRenderHelper;
import vazkii.botania.api.item.IBurstViewerBauble;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemMonocle
extends ItemBauble
implements IBurstViewerBauble,
ICosmeticBauble {
    public ItemMonocle(Item.Properties props) {
        super(props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean armor = !player.func_184582_a(EquipmentSlotType.HEAD).func_190926_b();
        AccessoryRenderHelper.translateToHeadLevel(ms, player, partialTicks);
        AccessoryRenderHelper.translateToFace(ms);
        AccessoryRenderHelper.defaultTransforms(ms);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        ms.func_227862_a_(0.5f, 0.5f, 0.5f);
        ms.func_227861_a_(0.5, (double)-0.2f, armor ? (double)0.12f : 0.0);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, ms, buffers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderHUD(PlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult ray = mc.field_71476_x;
        if (ray == null || ray.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = ((BlockRayTraceResult)ray).func_216350_a();
        BlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        player.field_70170_p.func_175625_s(pos);
        ItemStack dispStack = ItemStack.field_190927_a;
        String text = "";
        if (block == Blocks.field_150488_af) {
            dispStack = new ItemStack((IItemProvider)Items.field_151137_ax);
            text = TextFormatting.RED + "" + state.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O);
        } else if (block == Blocks.field_196633_cV) {
            dispStack = new ItemStack((IItemProvider)Blocks.field_196633_cV);
            text = "" + state.func_177229_b((IProperty)RepeaterBlock.field_176410_b);
        } else if (block == Blocks.field_196762_fd) {
            dispStack = new ItemStack((IItemProvider)Blocks.field_196762_fd);
            String string = text = state.func_177229_b((IProperty)ComparatorBlock.field_176463_b) == ComparatorMode.SUBTRACT ? "-" : "+";
        }
        if (dispStack.func_190926_b()) {
            return;
        }
        int x = mc.func_228018_at_().func_198107_o() / 2 + 15;
        int y = mc.func_228018_at_().func_198087_p() / 2 - 8;
        mc.func_175599_af().func_180450_b(dispStack, x, y);
        mc.field_71466_p.func_175063_a(text, (float)(x + 20), (float)(y + 4), 0xFFFFFF);
    }

    public static boolean hasMonocle(PlayerEntity player) {
        return (Boolean)EquipmentHandler.getAllWorn((LivingEntity)player).map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ICosmeticAttachable attach;
                ItemStack cosmetic;
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                if (item instanceof IBurstViewerBauble) {
                    return true;
                }
                if (!(item instanceof ICosmeticAttachable) || (cosmetic = (attach = (ICosmeticAttachable)item).getCosmeticItem(stack)).func_190926_b() || !(cosmetic.func_77973_b() instanceof IBurstViewerBauble)) continue;
                return true;
            }
            return false;
        }).orElse((Object)false);
    }
}

